<?php
/**
* +----------------------------------------------------------------------
 * Mysql配置
* +----------------------------------------------------------------------
 * 官网：https://www.sw-x.cn
 * +----------------------------------------------------------------------
 * 作者：小黄牛 <1731223728@qq.com>
 * +----------------------------------------------------------------------
 * 开源协议：http://www.apache.org/licenses/LICENSE-2.0
 * +----------------------------------------------------------------------
*/

return [
    // 是否开启连接数监控
    'is_monitor' => true,

    // host:端口，集群则参考MongoDb官网文档
    'host' => '127.0.0.1',
    //端口
    'port' => '5672',
    // 用户名
    'user'     => 'guest',
    // 密码
    'password' => 'guest',
    // broker地址
    'vhost'=>'/',
    // 连接池数量
    'pool_num' => 0,
    // 空闲连接池检测间隔时间(S)
    'monitor_time' => 1200,
    // 空闲连接回收时间(S)
    'spare_time' => 600,
    // 连接最长保持时间(0永久)，不建议修改
    'connectTimeoutMS' => 0,
    // 单条命令的最长执行时间(毫秒)
    'socketTimeoutMS' => 5000,

    // 打开包长检测特性
    'open_length_check'     => true,
    // 长度值的类型
    'package_length_type'   => 'N',
    // 第N个字节是包长度的值
    'package_length_offset' => 0,
    // 第几个字节开始计算长度
    'package_body_offset'   => 4,
    // 协议最大长度
    'package_max_length'    => 2000000,
];
