<?php

namespace app\http\api\api;
use x\controller\Http;
use x\Restful;

class copy extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        
        $api = $this->Db->name('api')->where('id', $param['id'])->find();
        if (!$api) {
            return Restful::code(Restful::ERROR())->setMsg('该接口已被删除')->callback();
        }
        unset($api['id']);
        $api['title'] .= '（副本）';

        if (!empty($param['group_id'])) {
            $success = $this->Db->name('api_success')->where('api_id', $param['id'])->select();
            $error = $this->Db->name('api_error')->where('api_id', $param['id'])->select();
            $request = $this->Db->name('api_request')->where('api_id', $param['id'])->select();
            $code = $this->Db->name('api_return_code')->where('api_id', $param['id'])->select();
            $return_request = $this->Db->name('api_return_request')->where('api_id', $param['id'])->select();
            $body = $this->Db->name('api_body')->where('api_id', $param['id'])->where('pid=0')->select();
            $return = $this->Db->name('api_return')->where('api_id', $param['id'])->where('pid=0')->select();

            $array = explode(',', $param['group_id']);
            foreach ($array as $group_id) {
                $api['group_id'] = $group_id;
                $api_id = $this->Db->name('api')->insertGetId($api);
                if (!$api_id) {
                    return Restful::code(Restful::ERROR())->setMsg('接口复制失败')->callback();
                }
                $this->Db->name('api')->where('id', $api_id)->update([
                    'sort' => $api_id
                ]);
                foreach ($success as $v) {
                    $v['api_id'] = $api_id;
                    $this->Db->name('api_success')->insert($v);
                }
                foreach ($error as $v) {
                    $v['api_id'] = $api_id;
                    $this->Db->name('api_error')->insert($v);
                }
                foreach ($request as $v) {
                    $v['api_id'] = $api_id;
                    $this->Db->name('api_request')->insert($v);
                }
                foreach ($code as $v) {
                    $v['api_id'] = $api_id;
                    $this->Db->name('api_return_code')->insert($v);
                }
                foreach ($return_request as $v) {
                    $v['api_id'] = $api_id;
                    $this->Db->name('api_return_request')->insert($v);
                }
                $this->body_insert($body, $api_id, 0);
                $this->return_insert($return, $api_id, 0);
            }
        } else {
            $api_id = $this->Db->name('api')->insertGetId($api);
            if (!$api_id) {
                return Restful::code(Restful::ERROR())->setMsg('接口复制失败')->callback();
            }
            $this->Db->name('api')->where('id', $api_id)->update([
                'sort' => $api_id
            ]);
            $success = $this->Db->name('api_success')->where('api_id', $param['id'])->select();
            foreach ($success as $v) {
                $v['api_id'] = $api_id;
                $this->Db->name('api_success')->insert($v);
            }
            $error = $this->Db->name('api_error')->where('api_id', $param['id'])->select();
            foreach ($error as $v) {
                $v['api_id'] = $api_id;
                $this->Db->name('api_error')->insert($v);
            }
            $request = $this->Db->name('api_request')->where('api_id', $param['id'])->select();
            foreach ($request as $v) {
                $v['api_id'] = $api_id;
                $this->Db->name('api_request')->insert($v);
            }
            $code = $this->Db->name('api_return_code')->where('api_id', $param['id'])->select();
            foreach ($code as $v) {
                $v['api_id'] = $api_id;
                $this->Db->name('api_return_code')->insert($v);
            }
            $return_request = $this->Db->name('api_return_request')->where('api_id', $param['id'])->select();
            foreach ($return_request as $v) {
                $v['api_id'] = $api_id;
                $this->Db->name('api_return_request')->insert($v);
            }
            $body = $this->Db->name('api_body')->where('api_id', $param['id'])->where('pid=0')->select();
            $return = $this->Db->name('api_return')->where('api_id', $param['id'])->where('pid=0')->select();
            $this->body_insert($body, $api_id, 0);
            $this->return_insert($return, $api_id, 0);
        }

        return Restful::code(Restful::SUCCESS())->setMsg('接口复制成功')->data([
            'id' => $api_id
        ])->callback();
    }

    private function body_insert($list, $api_id, $pid=0) {
        foreach ($list as $v) {
            $arr = $this->Db->name('api_body')->where('pid', $v['id'])->select();
            unset($v['id']);
            $v['pid'] = $pid;
            $v['api_id'] = $api_id;
            $id= $this->Db->name('api_body')->insertGetId($v);
            if ($arr) {
                $this->body_insert($arr, $api_id, $id);
            }
        }
    }
    private function return_insert($list, $api_id, $pid=0) {
        foreach ($list as $v) {
            $arr = $this->Db->name('api_return')->where('pid', $v['id'])->select();
            unset($v['id']);
            $v['pid'] = $pid;
            $v['api_id'] = $api_id;
            $id= $this->Db->name('api_return')->insertGetId($v);
            if ($arr) {
                $this->return_insert($arr, $api_id, $id);
            }
        }
    }
}