<?php

namespace app\http\api\api;
use x\controller\Http;
use x\Restful;

class delete extends Http
{
    private $json;

    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();

        $title = $this->trash($param['id']);

        
        $res = $this->Db->name('api')->where('id', $param['id'])->delete();
        if (!$res) {
            return Restful::code(Restful::ERROR())->setMsg('接口删除失败')->callback();
        }
        $this->Db->name('api_body')->where('api_id', $param['id'])->delete();
        $this->Db->name('api_success')->where('api_id', $param['id'])->delete();
        $this->Db->name('api_error')->where('api_id', $param['id'])->delete();
        $this->Db->name('api_request')->where('api_id', $param['id'])->delete();
        $this->Db->name('api_return')->where('api_id', $param['id'])->delete();
        $this->Db->name('api_return_code')->where('api_id', $param['id'])->delete();
        $this->Db->name('api_return_request')->where('api_id', $param['id'])->delete();

        $this->Db->name('trash')->insert([
            'title' => $title,
            'type' => 1,
            'create_time' => time(),
            'json' => $this->json,
        ]);

        return Restful::code(Restful::SUCCESS())->setMsg('接口删除成功')->callback();
    }

    
    private function trash($id) {
        $api = $this->Db->name('api')->where('id', $id)->find();
        $group = $this->Db->name('api_group')->where('id', $api['group_id'])->find();
        $item = $this->Db->name('item')->where('id', $api['item_id'])->find();
        $domain_id = $api['domain_id']!=0 ? $api['domain_id'] : $item['domain_id'];
        $return_id = $api['return_id']!=0 ? $api['return_id'] : $item['return_id'];

        $return = $this->Db->name('return')->where('id', $return_id)->find();
        $return['field'] = $this->Db->name('return_field')->where('pid', $return_id)->select();

        $json = [];
        $json['api'] = $api;
        $json['item'] = $item;
        $json['group'] = $group;
        $json['domain'] = $this->Db->name('domain')->where('id', $domain_id)->find();
        $json['return'] = $return;
        
        $json['api_body'] = $this->Db->name('api_body')->where('api_id', $id)->select();
        $json['api_success'] = $this->Db->name('api_success')->where('api_id', $id)->select();
        $json['api_error'] = $this->Db->name('api_error')->where('api_id', $id)->select();
        $json['api_request'] = $this->Db->name('api_request')->where('api_id', $id)->select();
        $json['api_return'] = $this->Db->name('api_return')->where('api_id', $id)->select();
        $json['api_return_code'] = $this->Db->name('api_return_code')->where('api_id', $id)->select();
        $json['api_return_request'] = $this->Db->name('api_return_request')->where('api_id', $id)->select();

        $this->json = json_encode($json, JSON_UNESCAPED_UNICODE);

        return $item['title'].'-'.$group['title'].'-'.$api['title'];
    }
}