<?php
namespace app\http\api\api;
use x\controller\Http;
use x\Restful;

class export_doc extends Http
{
    /**
     * @Get
     * @Param(name="token", empty="true", tips="缺少文档标识符")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::get();
        if (empty($param['token'])) return $this->fetch('NO~');
        $item = $this->Db->name('item')->where('doc_id', $param['token'])->find();
        if (!$item) return $this->fetch('NO~');

        $this->assign('param', $param);
        $this->assign('item', $item);
        $this->assign('token', $param['token']);

        $code = $this->Db->name('api')->alias('A')
                ->join('api_return_code B', 'A.id = B.api_id')
                ->where('A.item_id', $item['id'])
                ->where('A.display', 1)
                ->where('B.code', '<>', "")
                ->order('B.code ASC')
                ->group('B.code')
                ->field('B.*')
                ->select();
        if (count($code) == 1) {
            if ($code[0]['api_id'] === null) {
                $code = []; 
            }
        }
        foreach ($code as $k => $v) {
            $code[$k]['param_type'] = type_list($v['param_type']);
        }
        $this->assign('code', $code);

        $info = $this->Db->name('api_group')->where('item_id', $item['id'])->order('sort DESC, id ASC')->field('id, title')->select();
        foreach ($info as $k => $v) {
            $list = $this->Db->name('api')->where('group_id', $v['id'])->where('display', 1)->order('sort ASC')->select(); // 2022-1-25
            foreach ($list as $key => $val) {
                $list[$key] = $this->get_info($val, $val, $item);
            }
            $info[$k]['list'] = $list;
        }
        $this->assign('api', $info);
        
        $this->assign('var_list', $this->Db->name('test_variable')->order('id ASC')->select());

        $this->assign('fun_list', $this->Db->name('test_function')->order('id ASC')->select());
        $url = \x\Request::url(true);
        $arr = explode('/api/', $url);
        $this->assign('URL', $arr[0]);

        
        $html = '<html xmlns:o="urn:schemas-microsoft-com:office:office"
        xmlns:w="urn:schemas-microsoft-com:office:word"
        xmlns="http://www.w3.org/TR/REC-html40">';
        $html .= $this->view('apidoc/export_doc');
        return $this->fetch($html, 200, [
            "Content-type" => "application/word",
            "Accept-Ranges" => "bytes",
            'Content-disposition'=>'attachment; filename='.$item['title'].'-API接口文档.docx',
        ]);
    }

    public function get_info($return, $param, $item) {
        $return['type'] = request_list($return['request_type']);
        $return['param'] = param_list($return['param_type']);
        $return['group'] = $this->Db->name('api_group')->where('id', $return['group_id'])->value('title');
        $return['status'] = $this->Db->name('status')->where('id', $return['status'])->find();
        $return['update_time'] = formatTime($return['update_time']);

        if ($return['domain_id']) {
            $res = $this->Db->name('domain')->where('id', $return['domain_id'])->find();
        } else {
            $res = $this->Db->name('domain')->where('id', $item['domain_id'])->find();
        }
        $return['host_url'] = $res['domain'].$return['host_url'];
        if (stripos($res['domain'], 'https') !== false) {
            $return['http'] = 'HTTPS';
        } else {
            $return['http'] = 'HTTP';
        }
        if ($return['return_id']) {
            $res = $this->Db->name('return')->where('id', $return['return_id'])->find();
        } else {
            $res = $this->Db->name('return')->where('id', $item['return_id'])->find();
        }
        $return['return_type'] = param_list($res['return_type']);

        $return['return_field'] = $this->Db->name('return_field')->where('pid', $res['id'])->order('sort ASC')->select();
        
        $return['success_list'] = $this->Db->name('api_success')->where('api_id', $param['id'])->select();
        $return['error_list'] = $this->Db->name('api_error')->where('api_id', $param['id'])->select();

        $request = $this->Db->name('api_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        foreach ($request as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $request[$k] = $v;
        }
        $return['request'] = $request;

        $return_request = $this->Db->name('api_return_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        foreach ($return_request as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $return_request[$k] = $v;
        }
        $return['return_request'] = $return_request;

        $return_code = $this->Db->name('api_return_code')->where('api_id', $param['id'])->select();
        foreach ($return_code as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $return_code[$k] = $v;
        }
        $return['return_code'] = $return_code;

        $list = $this->Db->name('api_body')->where('api_id', $param['id'])->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $list[$k] = $v;
        }
        $list = $this->recursion($list);
        $this->html = [];
        foreach ($list as $k=>$v) {
            $arr = $v['list'];
            unset($v['list']);
            $this->html[] = $v;
            $this->html_insert($arr);
        }
        $return['body'] = $this->html;

        $list = $this->Db->name('api_return')->where('api_id', $param['id'])->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $list[$k] = $v;
        }
        $list = $this->recursion($list);
        $this->html = [];
        foreach ($list as $k=>$v) {
            $arr = $v['list'];
            unset($v['list']);
            $this->html[] = $v;
            $this->html_insert($arr);
        }
        $return['return'] = $this->html;

        $return['usecase_list'] = $this->Db->name('test_usecase')->where('api_id', $param['id'])->order('id ASC')->field('id, title')->select();

        return $return;
    }

    public function recursion($array='', $field1='id', $field2='pid', $menu = 'list', $pid = 0) {
        $arr = [];
        foreach ($array as $v) {
            if ($v[$field2] == $pid) {
                $v[$menu] = $this->recursion($array, $field1, $field2, $menu, $v[$field1]);
                $arr[] = $v;
            }
        }
        return $arr;
    }
    public function html_insert($list) {
        foreach ($list as $k=>$v) {
            $arr = $v['list'];
            unset($v['list']);
            $this->html[] = $v;
            $this->html_insert($arr);
        }
    }
}