<?php
namespace app\http\api\api;
use x\controller\Http;
use x\Restful;

class export_json extends Http
{
    /**
     * @Get
     * @Param(name="token", empty="true", tips="缺少文档标识符")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::get();
        if (empty($param['token'])) return $this->fetch('NO~');
        $item = $this->Db->name('item')->where('doc_id', $param['token'])->find();
        if (!$item) return $this->fetch('NO~');
        
        $json = [];
        
        $json['item'] = [
            'title' => $item['title'],
            'doc_id' => $item['doc_id'],
            'version' => $item['version'],
            'pwd' => $item['pwd'],
        ];

        $code = $this->Db->name('api')->alias('A')
                ->join('api_return_code B', 'A.id = B.api_id')
                ->where('A.item_id', $item['id'])
                ->where('A.display', 1)
                ->where('B.code', '<>', "")
                ->order('B.code ASC')
                ->group('B.code')
                ->field('B.*')
                ->select();
        if (count($code) == 1) {
            if ($code[0]['api_id'] === null) {
                $code = []; 
            }
        }
        
        $json['code'] = [];
        foreach ($code as $k => $v) {
            $code[$k]['param_type'] = type_list($v['param_type']);
            $json['code'][] = [
                'code' => $v['code'],
                'msg' => $v['msg'],
                'param_type' => type_list($v['param_type']),
            ];
        }
        
        $url = \x\Request::url(true);
        $arr = explode('/api/', $url);
        $url = $arr[0];

        $info = $this->Db->name('api_group')->where('item_id', $item['id'])->order('sort DESC, id ASC')->field('id, title')->select();
        foreach ($info as $k => $v) {
            $list = $this->Db->name('api')->where('group_id', $v['id'])->where('display', 1)->order('sort ASC')->select(); // 2022-1-25
            foreach ($list as $key => $val) {
                $list[$key] = $this->get_info($val, $val, $item);
            }
            $info[$k]['list'] = $list;
        }

        $json['api'] = [];
        foreach ($info as $kkey => $val) {
            foreach ($val['list'] as $num => $v) {
                $json['api'][] = $v;
            }
        }
        
        return $this->fetch(json_encode($json, JSON_UNESCAPED_UNICODE), 200, [
            "Content-type" => "application/word",
            "Accept-Ranges" => "bytes",
            'Content-disposition'=>'attachment; filename='.$item['title'].'-API接口文档.json',
        ]);
    }

    public function get_info($return, $param, $item) {
        $return['type'] = request_list($return['request_type']);
        $return['param'] = param_list($return['param_type']);
        $return['group'] = $this->Db->name('api_group')->where('id', $return['group_id'])->value('title');
        $return['status'] = $this->Db->name('status')->where('id', $return['status'])->find();
        $return['update_time'] = formatTime($return['update_time']);

        if ($return['domain_id']) {
            $res = $this->Db->name('domain')->where('id', $return['domain_id'])->find();
        } else {
            $res = $this->Db->name('domain')->where('id', $item['domain_id'])->find();
        }
        $return['host_url'] = $res['domain'].$return['host_url'];
        if (stripos($res['domain'], 'https') !== false) {
            $return['http'] = 'HTTPS';
        } else {
            $return['http'] = 'HTTP';
        }
        if ($return['return_id']) {
            $res = $this->Db->name('return')->where('id', $return['return_id'])->find();
        } else {
            $res = $this->Db->name('return')->where('id', $item['return_id'])->find();
        }
        $return['return_type'] = param_list($res['return_type']);

        $return['return_field'] = $this->Db->name('return_field')->where('pid', $res['id'])->order('sort ASC')->select();
        
        $return['success_list'] = $this->Db->name('api_success')->where('api_id', $param['id'])->select();
        $return['error_list'] = $this->Db->name('api_error')->where('api_id', $param['id'])->select();

        $request = $this->Db->name('api_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        foreach ($request as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            if ($v['no_null']==1) {$v['no_null'] = '必填';}else{$v['no_null'] = '';}
            $request[$k] = $v;
        }
        $return['request'] = $request;

        $return_request = $this->Db->name('api_return_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        foreach ($return_request as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            if ($v['size']) $v['param_type'] .= '('.$v['size'].')';
            unset($v['size']);
            if ($v['no_null']==1) {$v['no_null'] = '必填';}else{$v['no_null'] = '';}
            $return_request[$k] = $v;
        }
        $return['return_request'] = $return_request;

        $return_code = $this->Db->name('api_return_code')->where('api_id', $param['id'])->select();
        foreach ($return_code as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $return_code[$k] = $v;
        }
        $return['return_code'] = $return_code;

        $list = $this->Db->name('api_body')->where('api_id', $param['id'])->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            if ($v['size']) $v['param_type'] .= '('.$v['size'].')';
            unset($v['size']);
            if ($v['no_null']==1) {$v['no_null'] = '必填';}else{$v['no_null'] = '';}
            $list[$k] = $v;
        }
        $return['body'] = $this->recursion($list);

        $list = $this->Db->name('api_return')->where('api_id', $param['id'])->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            if ($v['size']) $v['param_type'] .= '('.$v['size'].')';
            unset($v['size']);
            if ($v['no_null']==1) {$v['no_null'] = '必填';}else{$v['no_null'] = '';}
            $list[$k] = $v;
        }
        $return['return'] = $this->recursion($list);

        $list = $this->Db->name('test_usecase_group')->where('api_id', $param['id'])->order('id ASC')->field('id, title')->select();
        foreach ($list as $k => $v) {
            $list[$k]['list'] = $this->Db->name('test_usecase')->where('group_id', $v['id'])->order('id ASC')->field('id, title')->select();
        }
        $return['usecase_list'] = $list;

        $return['usecase_list'] = $this->Db->name('test_usecase')->where('api_id', $param['id'])->order('id ASC')->field('id, title')->select();

        return $return;
    }

    public function recursion($array='', $field1='id', $field2='pid', $menu = 'list', $pid = 0) {
        $arr = [];
        foreach ($array as $v) {
            if ($v[$field2] == $pid) {
                $v[$menu] = $this->recursion($array, $field1, $field2, $menu, $v[$field1]);
                $arr[] = $v;
            }
        }
        return $arr;
    }
}