<?php
namespace app\http\api\api;
use x\controller\Http;
use x\Restful;

class import_json extends Http
{
    /**
     * @Post
     * @Param(name="json", empty="true", tips="请输入需要解析的文本")
    */
    public function index() {
        $param = \x\Request::post();
        $json = $param['json'];
        $arr = json_decode($json, true);
        if (is_array($arr)) {
            if (isset($arr[0]['key']) && isset($arr[0]['value']) && isset($arr[0]['description'])) {
                
                $list = $arr;
                $type = 2;
            } else {
                
                $list = self::scene_one($arr);
                $type = 1;
            }
        } else {
            $res_1 = strpos($json, '`');
            $res_2 = stripos($json, 'DEFAULT');
            $res_3 = strpos($json, ',');
            if ($res_1 !== false && $res_2 !== false && $res_3 !== false) {
               
                $str = preg_replace("/\s(?=\s)/","\\1", $json);
                $arr = explode(',', str_replace(['<br/>', "\r", "\n"], PHP_EOL, $str));
                foreach ($arr as $v) {
                    if (empty($v)) continue;
                    $preg= '/`(.*)`/i';
                    preg_match_all($preg, $v, $res);
                    $key = isset($res[1][0]) ? $res[1][0] : '';

                    $preg= "/DEFAULT '(.*)'/i";
                    preg_match_all($preg, $v, $res);
                    if (isset($res[1][0])) {
                        $a = explode("'", $res[1][0]);
                        $val = $a[0];
                    } else {
                        $val = '';
                    }

                    $preg= "/COMMENT '(.*)'/i";
                    preg_match_all($preg, $v, $res);
                    if (isset($res[1][0])) {
                        $a = explode("'", $res[1][0]);
                        $des = $a[0];
                    } else {
                        $des = '';
                    }

                    $list[] = [
                        'key' => $key,
                        'value' => $val,
                        'description' => $des,
                    ];
                }
                $type = 3;
            } else {
                
                $str = preg_replace("/\s(?=\s)/","\\1", $json);
                $str = str_replace(['<br/>', "\r", "\n"], PHP_EOL, $str);
                $str = str_replace(['	'], ' ', $str);
                foreach ($arr as $v) {
                    if (empty($v)) continue;
                    $start = strpos($v, ' ');
                    $des = substr($v, $start);
                    $key = str_replace($des, '', $v);
                    $list[] = [
                        'key' => $key,
                        'value' => '',
                        'description' => ltrim($des, ' '),
                    ];
                }
                $type = 3;
            }
        }

        if (empty($list)) {
            return Restful::code(Restful::ERROR())->setMsg('解析失败')->callback();
        }
        
        return Restful::code(Restful::SUCCESS())->setMsg('解析成功')->data([
            'type' => $type,
            'list' => $list,
        ])->callback();
    }

    public static function scene_one($arr) {
        
        $list = [];
        foreach ($arr as $k=>$v){
            if (!is_array($v) || (is_array($v) && empty($v))) {
                $list[] = $k;
            } else {
                
                $treeArray = self::tree($k, $v);
                $list = array_merge($list, $treeArray);
            }
        }

        return $list;
    }

    private static function tree($title, $arr, $list = []) {
        foreach ($arr as $k => $v) {
            
            if (!is_array($v) || (is_array($v) && empty($v))) {
                $list[] = $title.'['.$k.']';
            } else {
                
                return self::tree($title.'['.$k.']', $v, $list);
            }
        }

        return $list;
    }
}