<?php

namespace app\http\api\api;
use x\controller\Http;
use x\Restful;

class info extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();

        $info = $this->Db->name('api')->where('id', $param['id'])->find();
        if (!$info) {
            return Restful::code(Restful::ERROR())->setMsg('接口信息读取失败')->callback();
        }
        
        $info['group'] = $this->Db->name('api_group')->where('id', $info['group_id'])->value('title');
        
        $info['success_list'] = $this->Db->name('api_success')->where('api_id', $param['id'])->select();
        $info['error_list'] = $this->Db->name('api_error')->where('api_id', $param['id'])->select();
        
        $info['request_list'] = $this->Db->name('api_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        
        $info['return_request_list'] = $this->Db->name('api_return_request')->where('api_id', $param['id'])->order('sort ASC')->select();
       
        $info['code_list'] = $this->Db->name('api_return_code')->where('api_id', $param['id'])->select();
        
        $list = $this->Db->name('api_body')->where('api_id', $param['id'])->order('id ASC')->select();
        $info['param_list'] = $this->recursion($list);
        
        $list = $this->Db->name('api_return')->where('api_id', $param['id'])->order('id ASC')->select();
        $info['return_list'] = $this->recursion($list);
        
        return Restful::code(Restful::SUCCESS())->setMsg('接口详情读取完成')->data($info)->callback();
    }

    public function recursion($array='', $field1='id', $field2='pid', $menu = 'list', $pid = 0) {
        $arr = [];
        foreach ($array as $v) {
            if ($v[$field2] == $pid) {
                $v[$menu] = $this->recursion($array, $field1, $field2, $menu, $v[$field1]);
                $arr[] = $v;
            }
        }
        return $arr;
    }
}