<?php

namespace app\http\api\api;
use x\controller\Http;
use x\Restful;

class update extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="title", empty="true", tips="请输入接口名称")
     * @Param(name="group", empty="true", tips="请输入所属分组")
     * @Param(name="host_url", empty="true", tips="请输入接口地址")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        if (!empty($param['request'])) {
            foreach ($param['request'] as $v) {
                if (empty($v['field'])) {
                    return Restful::code(Restful::ERROR())->setMsg('请求头字段名不能为空')->callback();
                }
            }
        }
        if (!empty($param['code'])) {
            foreach ($param['code'] as $v) {
                if (str_replace(' ', '', $v['code']) === '') {
                    return Restful::code(Restful::ERROR())->setMsg('返回值Code字段不能为空')->callback();
                }
            }
        }
        if (!empty($param['return_request'])) {
            foreach ($param['return_request'] as $v) {
                if (empty($v['field'])) {
                    return Restful::code(Restful::ERROR())->setMsg('返回头部字段名不能为空')->callback();
                }
            }
        }
        if (!empty($param['return'])) {
            foreach ($param['return'] as $v) {
                if (empty($v['field'])) {
                    return Restful::code(Restful::ERROR())->setMsg('返回值字段名不能为空')->callback();
                }
                foreach ($v as $val) {
                    if (is_array($val) && is_null($val['field'])) {
                        return Restful::code(Restful::ERROR())->setMsg('返回值二级字段名不能为空')->callback();
                    }
                }
            }
        }
        if (!empty($param['param'])) {
            foreach ($param['param'] as $v) {
                if (empty($v['field'])) {
                    return Restful::code(Restful::ERROR())->setMsg('请求体字段名不能为空')->callback();
                }
                foreach ($v as $val) {
                    if (is_array($val) && is_null($val['field'])) {
                        return Restful::code(Restful::ERROR())->setMsg('请求体二级字段名不能为空')->callback();
                    }
                }
            }
        }
        
        $info = $this->Db->name('api')->where('id', $param['id'])->field('item_id, is_imitate_api, imitate_code')->find();

        $group_id = $this->Db->name('api_group')->where('item_id', $info['item_id'])->where('title', $param['group'])->value('id');
        if (!$group_id) {
            $group_id = $this->Db->name('api_group')->insertGetId([
                'item_id' => $info['item_id'],
                'title' => $param['group'],
                'create_time' => time(),
                'des' => '系统自动创建'
            ]);
        }
        $res = $this->Db->name('api')->where('item_id', $info['item_id'])->where('group_id', $group_id)->where('title', $param['title'])->where('id', '<>', $param['id'])->value('id');
        if ($res) {
            return Restful::code(Restful::ERROR())->setMsg('该接口名称已重复')->callback();
        }

        if ($param['is_imitate_api'] == 1 && empty($param['imitate_route'])) {
            if ($param['domain_id'] == 0) {
                $domain_id = $this->Db->name('item')->where('id', $info['item_id'])->value('domain_id');
            } else {
                $domain_id = $param['domain_id'];
            }
            $domain = $this->Db->name('domain')->where('id', $domain_id)->value('domain');
            $host_url = $domain.$param['host_url'];
            $parse_url = parse_url($host_url);
            $domain = '';
            if (isset($parse_url['host'])) {
                $domain = $parse_url['scheme'].'://'.$parse_url['host'];
                if (isset($parse_url['port'])) $domain .= ':'.$parse_url['port'];
            }
            $param['imitate_route'] = str_replace($domain, '', $host_url);
        }
        
        if (!empty($param['imitate_route'])) {
            $param['imitate_route'] = '/'.ltrim($param['imitate_route'], '/');
            $no_route = [
                '/apiword', '/auth', '/word', '/test', '/code', '/robot', '/apidoc', '/archives'
            ];
            foreach ($no_route as $v) {
                if (stripos($param['imitate_route'], $v) === 0) {
                    return Restful::code(Restful::ERROR())->setMsg('模拟接口路由 包括系统关键词：'.$v)->callback();
                }
            }
            $res = $this->Db->name('api')->where('imitate_route', $param['imitate_route'])->where('id', '<>', $param['id'])->value('id');
            if ($res) return Restful::code(Restful::ERROR())->setMsg('模拟接口路由 已被使用')->callback();
        }

        $data = [];
        $data['update_time'] = time();
        $data['status'] = $param['status'];
        $data['display'] = $param['display'];
        $data['title'] = $param['title'];
        $data['group_id'] = $group_id;
        $data['duty_name'] = $param['duty_name'];
        $data['domain_id'] = $param['domain_id'];
        $data['return_id'] = $param['return_id'];
        $data['request_type'] = $param['request_type'];
        $data['host_url'] = $param['host_url'];
        $data['action'] = $param['action'];
        $data['param_type'] = $param['param_type'];
        $data['content2'] = $param['content2'];
        $data['des'] = $param['des'];
        $data['is_imitate_api'] = $param['is_imitate_api'];
        $data['imitate_route'] = $param['imitate_route'];
        $data['imitate_code'] = $param['imitate_code'];
        $res = $this->Db->name('api')->where('id', $param['id'])->update($data);
        if (!$res) {
            return Restful::code(Restful::ERROR())->setMsg('接口修改失败')->callback();
        }
        $pid = $param['id'];

        $this->Db->name('api_request')->where('api_id', $pid)->delete();
        $this->Db->name('api_return_code')->where('api_id', $pid)->delete();
        $this->Db->name('api_return_request')->where('api_id', $pid)->delete();
        $this->Db->name('api_return')->where('api_id', $pid)->delete();
        $this->Db->name('api_body')->where('api_id', $pid)->delete();
        $this->Db->name('api_success')->where('api_id', $pid)->delete();
        $this->Db->name('api_error')->where('api_id', $pid)->delete();

        if (!empty($param['request'])) {
            foreach ($param['request'] as $k=>$v) {
                $v['api_id'] = $pid;
                $v['sort'] = $k;
                $v['param_type'] = $v['type'];
                $v['no_null'] = $v['no_null'] ?? 0;
                unset($v['type']);
                $this->Db->name('api_request')->insert($v);
            }
        }
        if (!empty($param['code'])) {
            foreach ($param['code'] as $k=>$v) {
                $v['api_id'] = $pid;
                $v['sort'] = $k;
                $v['param_type'] = $v['type'];
                $v['code'] = (string)$v['code'];
                $v['is_success'] = $v['is_success'] ?? 0;
                unset($v['type']);
                $this->Db->name('api_return_code')->insert($v);
            }
        }
        if (!empty($param['return_request'])) {
            foreach ($param['return_request'] as $k=>$v) {
                $v['api_id'] = $pid;
                $v['sort'] = $k;
                $v['param_type'] = $v['type'];
                $v['no_null'] = $v['no_null'] ?? 0;
                unset($v['type']);
                $this->Db->name('api_return_request')->insert($v);
            }
        }
        if (!empty($param['return'])) {
            $this->return_insert($pid, $param['return']);
        }
        if (!empty($param['param'])) {
            $this->body_insert($pid, $param['param']);
        }

        if (!empty($param['success'])) {
            foreach ($param['success'] as $k=>$v) {
                $v['api_id'] = $pid;
                $this->Db->name('api_success')->insert($v);
            }
        }
        if (!empty($param['error'])) {
            foreach ($param['error'] as $k=>$v) {
                $v['api_id'] = $pid;
                $this->Db->name('api_error')->insert($v);
            }
        }

        if ($param['is_imitate_api'] == 1 && $info['imitate_code'] != $param['imitate_code']) {
            $idJson = file_get_contents(\x\Config::get('server.pid_file'));  
            $idArray = json_decode($idJson, true);
            posix_kill($idArray['manager_pid'], SIGUSR1);
        }

        return Restful::code(Restful::SUCCESS())->setMsg('接口修改成功')->callback();
    }

    public function return_insert($api_id, $list, $pid=0, $level=0) {
        foreach ($list as $v) {
            $data = [
                'pid' => $pid,
                'api_id' => $api_id, 
                'level' => $level,
                'field' => $v['field'],
                'title' => $v['title'],
                'param_type' => $v['type'],
                'no_null' => $v['no_null'] ?? 0,
                'default' => $v['default'],
                'size' => $v['size']??'',
            ];
            $cid = $this->Db->name('api_return')->insertGetId($data);
            if ($cid) {
                foreach ($v as $val) {
                    if (is_array($val)) {
                        $this->return_insert($api_id, [$val], $cid, ($level+1));
                    }
                }
            }
        }
    }

    public function body_insert($api_id, $list, $pid=0, $level=0) {
        foreach ($list as $v) {
            $data = [
                'pid' => $pid,
                'api_id' => $api_id, 
                'level' => $level,
                'field' => $v['field'],
                'title' => $v['title'],
                'param_type' => $v['type'],
                'no_null' => $v['no_null'] ?? 0,
                'default' => $v['default'],
                'size' => $v['size']??'',
            ];
            $cid = $this->Db->name('api_body')->insertGetId($data);
            if ($cid) {
                foreach ($v as $val) {
                    if (is_array($val)) {
                        $this->body_insert($api_id, [$val], $cid, ($level+1));
                    }
                }
            }
        }
    }
}