<?php
namespace app\http\api\api;
use x\controller\Http;
use x\Restful;
use x\Session;

class version_send extends Http
{
    private $content = '';
    
    private $status=false;
    
    private $status2=false;

    /**
     * @Post
     * @Param(name="item_id", empty="true", tips="请输入项目ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $item_id = $param['item_id'];
        $admin = Session::get('admin');

        $Db = new \x\Db();
        $top_version = $Db->name('version_log')->where('item_id', $item_id)->order('id DESC')->find();
        
        if ($top_version == false) {
            $this->createLog('首个孵化版本', 1);
            $res = $this->save(false, [
                'code' => 'v1.0.1',
                'item_id' => $item_id,
                'admin_name' => $admin['fullname'],
                'content' => $this->content,
                'create_time' => time(),
            ]);
            $Db->name('item')->where('id', $item_id)->update([
                'version' => 'v1.0.1',
                'update_time' => time(),
            ]);
        } else {
            $this->update_query($item_id, $top_version['id']);
            if (empty($this->content)) {
                return Restful::code(Restful::ERROR())->setMsg('当前版本无更新内容，不允许发布新版本')->callback();
            }
            $code = str_replace('v', '', $top_version['code']);
            
            $arr = explode('.', $code);
            if ($arr[2] >= 39) {
                $arr[2] = 1;
                $arr[1]++;
            } else if ($arr[1] >= 10) {
                $arr[2] = 1;
                $arr[1] = 0;
                $arr[0]++;
            } else {
                $arr[2]++;
            }
            $version = 'v'.implode('.',$arr);
            
            $res = $this->save($top_version['id'], [
                'code' => $version,
                'item_id' => $item_id,
                'admin_name' => $admin['fullname'],
                'content' => $this->content,
                'create_time' => time(),
            ]);
            $Db->name('item')->where('id', $item_id)->update([
                'version' => $version,
                'update_time' => time(),
            ]);
        }

        return Restful::code(Restful::SUCCESS())->setMsg('发布成功')->callback();
    }

    private function save($top_version_id, $data) {
        $Db = new \x\Db();
        if ($top_version_id) {
            $Db->name('version_api')->where('version_id', $top_version_id)->delete();
            $Db->name('version_api_body')->where('version_id', $top_version_id)->delete();
            $Db->name('version_api_error')->where('version_id', $top_version_id)->delete();
            $Db->name('version_api_group')->where('version_id', $top_version_id)->delete();
            $Db->name('version_api_request')->where('version_id', $top_version_id)->delete();
            $Db->name('version_api_return')->where('version_id', $top_version_id)->delete();
            $Db->name('version_api_return_code')->where('version_id', $top_version_id)->delete();
            $Db->name('version_api_return_request')->where('version_id', $top_version_id)->delete();
            $Db->name('version_api_success')->where('version_id', $top_version_id)->delete();
        }
        $new_version_id = $Db->name('version_log')->insertGetId($data);
        if (!$new_version_id) {
            $Db->return();
            return false;
        }
        $api = $Db->name('api')->where('item_id', $data['item_id'])->select();
        foreach ($api as $v) {
            $v['version_id'] = $new_version_id;
            $Db->name('version_api')->insert($v);
            $body = $Db->name('api_body')->where('api_id', $v['id'])->select();
            foreach ($body as $vv) {
                $vv['version_id'] = $new_version_id;
                $Db->name('version_api_body')->insert($vv);
            }
            $error = $Db->name('api_error')->where('api_id', $v['id'])->select();
            foreach ($error as $vv) {
                $vv['version_id'] = $new_version_id;
                $Db->name('version_api_error')->insert($vv);
            }
            $success = $Db->name('api_success')->where('api_id', $v['id'])->select();
            foreach ($success as $vv) {
                $vv['version_id'] = $new_version_id;
                $Db->name('version_api_success')->insert($vv);
            }
            $request = $Db->name('api_request')->where('api_id', $v['id'])->select();
            foreach ($request as $vv) {
                $vv['version_id'] = $new_version_id;
                $Db->name('version_api_request')->insert($vv);
            }
            $return = $Db->name('api_return')->where('api_id', $v['id'])->select();
            foreach ($return as $vv) {
                $vv['version_id'] = $new_version_id;
                $Db->name('version_api_return')->insert($vv);
            }
            $return_code = $Db->name('api_return_code')->where('api_id', $v['id'])->select();
            foreach ($return_code as $vv) {
                $vv['version_id'] = $new_version_id;
                $Db->name('version_api_return_code')->insert($vv);
            }
            $return_request = $Db->name('api_return_request')->where('api_id', $v['id'])->select();
            foreach ($return_request as $vv) {
                $vv['version_id'] = $new_version_id;
                $Db->name('version_api_return_request')->insert($vv);
            }
        }
        $group = $Db->name('api_group')->where('item_id', $data['item_id'])->select();
        foreach ($group as $v) {
            $v['version_id'] = $new_version_id;
            $Db->name('version_api_group')->insert($v);
        }

        $Db->return();
        return true;
    }

    private function update_query($item_id, $top_version_id) {
        $JsonToTree = new \Task\JsonToTree();
        $Db = new \x\Db();
        $group = $Db->name('api_group')->where('item_id', $item_id)->select();
        $log_group = $Db->name('version_api_group')->where('version_id', $top_version_id)->select();
         
        foreach ($log_group as $v) {
            foreach ($group as $vv) {
                if ($v['id'] == $vv['id'] && $v['title'] != $vv['title']) {
                    $this->createLog('【修改】（分组）<code>'.$v['title'].'</code>改为<code>'.$vv['title'].'</code>');
                    unset($v['id']);
                    unset($vv['id']);
                    break;
                }
            }
        }
        foreach ($log_group as $v) {
            $info = false;
            foreach ($group as $vv) {
                if ($v['id'] == $vv['id']) {
                    $info = true;
                    break;
                }
            }
            if ($info == false) {
                $this->createLog('【删除】（分组）<code>'.$v['title'].'</code>');
            }
        }
        foreach ($group as $v) {
            $info = true;
            foreach ($log_group as $vv) {
                if ($v['id'] == $vv['id']) {
                    $info = false;
                    break;
                }
            }
            if ($info) {
                $this->createLog('【新增】（分组）<code>'.$v['title'].'</code>');
            }
        }
        $api = $Db->name('api')->alias('A')->join('api_group B','A.group_id=B.id')->where('A.item_id', $item_id)->field('A.*, B.title as group_title')->select();
        $log_api = $Db->name('version_api')->alias('A')->join('version_api_group B','A.group_id=B.id')->where('A.version_id', $top_version_id)->field('A.*, B.title as group_title')->select();
         
        foreach ($log_api as $v) {
            $this->status = false;
            foreach ($api as $vv) {
                if ($v['id'] == $vv['id'] && $v['title'] != $vv['title']) {
                    $this->checkApiSaveLog($v);
                    $this->createLog('接口名称：<code>'.$v['title'].'</code>改为<code>'.$vv['title'].'</code>', 2);
                }
                if ($v['id'] == $vv['id'] && $v['host_url'] != $vv['host_url']) {
                    $this->checkApiSaveLog($v);
                    $this->createLog('请求地址：<code>'.$v['host_url'].'</code>改为<code>'.$vv['host_url'].'</code>', 2);
                }
                if ($v['id'] == $vv['id'] && $v['param_type'] != $vv['param_type']) {
                    $this->checkApiSaveLog($v);
                    $this->createLog('数据类型：<code>'.param_list($v['param_type']).'</code>改为<code>'.param_list($vv['param_type']).'</code>', 2);
                }
                if ($v['id'] == $vv['id'] && $v['request_type'] != $vv['request_type']) {
                    $this->checkApiSaveLog($v);
                    $this->createLog('请求类型：<code>'.request_list($v['request_type']).'</code>改为<code>'.request_list($vv['request_type']).'</code>', 2);
                }
                if ($v['id'] == $vv['id'] && $v['return_id'] != $vv['return_id']) {
                    $this->checkApiSaveLog($v);
                    $this->createLog('修改了默认的返回数据结构格式', 2);
                }
                if ($v['id'] == $vv['id'] && $v['des'] != $vv['des']) {
                    $this->checkApiSaveLog($v);
                    $this->createLog('修改了接口摘要说明', 2);
                }
                if ($v['id'] == $vv['id'] && $v['content2'] != $vv['content2']) {
                    $this->checkApiSaveLog($v);
                    $this->createLog('修改了该接口文档说明', 2);
                }

                $code = $Db->name('api_return_code')->where('api_id', $v['id'])->select();
                $log_code = $Db->name('version_api_return_code')->where('api_id', $v['id'])->select();
                
                foreach ($log_code as $a) {
                    $code_status = false;
                    foreach ($code as $aa) {
                        if ($a['code'] == $aa['code']) {
                            $code_status = true;
                            break;
                        }
                    }
                    if ($code_status == false) {
                        $this->checkApiSaveLog($v);
                        $this->createLog('【删除】（状态码）<code>'.$a['code'].'</code>，'.$a['msg'], 3);
                    }
                }
                
                foreach ($code as $a) {
                    $code_status = true;
                    foreach ($log_code as $aa) {
                        if ($a['code'] == $aa['code']) {
                            $code_status = false;
                            break;
                        }
                    }
                    if ($code_status) {
                        $this->checkApiSaveLog($v);
                        $this->createLog('【新增】（状态码）<code>'.$a['code'].'</code>，'.$a['msg'], 3);
                    }
                }

                $field = $Db->name('api_body')->where('api_id', $v['id'])->select();
                $log_field = $Db->name('version_api_body')->where('api_id', $v['id'])->order('id ASC')->select();
                
                $field = $JsonToTree->analysis($field);
                $log_field = $JsonToTree->analysis($log_field);
                foreach ($log_field as $field_a=>$a) {
                    $this->status2 = false;
                    foreach ($field as $field_aa=>$aa) {
                        if ($field_a == $field_aa && $a['title'] != $aa['title']) {
                            $this->checkFieldSaveLog($field_a, $v, '请求字段');
                            $this->createLog('字段名称：<code>'.$a['title'].'</code>改为<code>'.$aa['title'].'</code>', 4);
                        }
                        if ($field_a == $field_aa && $a['default'] != $aa['default']) {
                            $this->checkFieldSaveLog($field_a, $v, '请求字段');
                            $this->createLog('默认值：<code>'.($a['default'] ?:'空 ').'</code>改为<code>'.($aa['default'] ?: '空').'</code>', 4);
                        }
                        if ($field_a == $field_aa && $a['param_type'] != $aa['param_type']) {
                            $this->checkFieldSaveLog($field_a, $v, '请求字段');
                            $this->createLog('字段类型：<code>'.type_list($a['param_type']).'</code>改为<code>'.type_list($aa['param_type']).'</code>', 4);
                        }
                        if ($field_a == $field_aa && $a['size'] != $aa['size']) {
                            $this->checkFieldSaveLog($field_a, $v, '请求字段');
                            $this->createLog('字段长度：<code>'.($a['size'] ?: '空').'</code>改为<code>'.($aa['size'] ?: '空').'</code>', 4);
                        }
                        if ($field_a == $field_aa && $a['no_null'] != $aa['no_null']) {
                            $this->checkFieldSaveLog($field_a, $v, '请求字段');
                            $this->createLog('必填：<code>'.($a['no_null'] ? '是' : '否').'</code>改为<code>'.($aa['no_null'] ? '是' : '否').'</code>', 4);
                        }
                    }
                    if ($this->status2 == true) {
                        unset($a['id']);
                        unset($aa['id']);
                        break;
                    }
                } 
                $arr = [];
                foreach ($log_field as $key=>$a) {
                    $info2 = false;
                    foreach ($field as $aa) {
                        if ($a['id'] == $aa['id']) {
                            $info2 = true;
                            break;
                        }
                    }
                    if ($info2 == false) {
                        $this->checkApiSaveLog($v);
                        $arr[$key] = 1;
                    }
                }
                foreach ($field as $key=>$a) {
                    $info2 = true;
                    foreach ($log_field as $aa) {
                        if ($a['id'] == $aa['id']) {
                            $info2 = false;
                            break;
                        }
                    }
                    if ($info2) {
                        $this->checkApiSaveLog($v);
                        if (empty($arr[$key])) {
                            $title = '【'.$a['title'].'】';
                            $arr[$key] = $title;
                        } else {
                            unset($arr[$key]);
                        }
                    }
                }
                foreach ($arr as $key => $val) {
                    if ($val == 1) {
                        $this->createLog('删除请求字段：<code>'.$key.'</code>', 3);
                    } else {
                        $this->createLog('新增请求字段：<code>'.$key.'</code>'.$val, 3);
                    }
                }


                $field = $Db->name('api_return')->where('api_id', $v['id'])->select();
                $log_field = $Db->name('version_api_return')->where('api_id', $v['id'])->select();
                
                $field = $JsonToTree->analysis($field);
                $log_field = $JsonToTree->analysis($log_field);
                foreach ($log_field as $field_a => $a) {
                    $this->status2 = false;
                    foreach ($field as $field_aa => $aa) {
                        if ($field_a == $field_aa && $a['title'] != $aa['title']) {
                            $this->checkFieldSaveLog($field_a, $v, '返回值字段');
                            $this->createLog('字段名称：<code>'.$a['title'].'</code>改为<code>'.$aa['title'].'</code>', 4);
                        }
                        if ($field_a == $field_aa && $a['default'] != $aa['default']) {
                            $this->checkFieldSaveLog($field_a, $v, '返回值字段');
                            $this->createLog('默认值：<code>'.($a['default'] ?:'空 ').'</code>改为<code>'.($aa['default'] ?: '空').'</code>', 4);
                        }
                        if ($field_a == $field_aa && $a['param_type'] != $aa['param_type']) {
                            $this->checkFieldSaveLog($field_a, $v, '返回值字段');
                            $this->createLog('字段类型：<code>'.type_list($a['param_type']).'</code>改为<code>'.type_list($aa['param_type']).'</code>', 4);
                        }
                        if ($field_a == $field_aa && $a['size'] != $aa['size']) {
                            $this->checkFieldSaveLog($field_a, $v, '返回值字段');
                            $this->createLog('字段长度：<code>'.($a['size'] ?: '空').'</code>改为<code>'.($aa['size'] ?: '空').'</code>', 4);
                        }
                        if ($field_a == $field_aa && $a['no_null'] != $aa['no_null']) {
                            $this->checkFieldSaveLog($field_a, $v, '返回值字段');
                            $this->createLog('必填：<code>'.($a['no_null'] ? '是' : '否').'</code>改为<code>'.($aa['no_null'] ? '是' : '否').'</code>', 4);
                        }
                    }
                    if ($this->status2 == true) {
                        unset($a['id']);
                        unset($aa['id']);
                        break;
                    }
                }
                $arr = [];
                foreach ($log_field as $key=>$a) {
                    $info2 = false;
                    foreach ($field as $aa) {
                        if ($a['id'] == $aa['id']) {
                            $info2 = true;
                            break;
                        }
                    }
                    if ($info2 == false) {
                        $this->checkApiSaveLog($v);
                        $arr[$key] = 1;
                    }
                }
                foreach ($field as $key=>$a) {
                    $info2 = true;
                    foreach ($log_field as $aa) {
                        if ($a['id'] == $aa['id']) {
                            $info2 = false;
                            break;
                        }
                    }
                    if ($info2) {
                        $this->checkApiSaveLog($v);
                        if (empty($arr[$key])) {
                            $title = '【'.$a['title'].'】';
                            $arr[$key] = $title;
                        } else {
                            unset($arr[$key]);
                        }
                    }
                }
                foreach ($arr as $key => $val) {
                    if ($val == 1) {
                        $this->createLog('删除返回值字段：<code>'.$key.'</code>', 3);
                    } else {
                        $this->createLog('新增返回值字段：<code>'.$key.'</code>'.$val, 3);
                    }
                }

                if ($this->status == true) {
                    unset($v['id']);
                    unset($vv['id']);
                    break;
                }
            }
        }
        foreach ($api as $v) {
            $info = true;
            foreach ($log_api as $vv) {
                if ($v['id'] == $vv['id']) {
                    $info = false;
                    break;
                }
            }
            if ($info) {
                $this->createLog('【新增】（接口）<font>'.$v['group_title'].' - '.$v['title'].'</font>');
            }
        }
        foreach ($log_api as $v) {
            $info = false;
            foreach ($api as $vv) {
                if ($v['id'] == $vv['id']) {
                    $info = true;
                    break;
                }
            }
            if ($info == false) {
                $this->createLog('【删除】（接口）<font>'.$v['group_title'].' - '.$v['title'].'</font>');
            }
        }
        
        $Db->return();
    }

    private function checkApiSaveLog($v) {
        if ($this->status == false) {
            $this->status = true;
            $this->createLog('【修改】（接口）<font>'.$v['group_title'].' - '.$v['title'].'</font>');
        }
    }
    private function checkFieldSaveLog($field, $api, $title) {
        if ($this->status2 == false) {
            $this->checkApiSaveLog($api);
            $this->status2 = true;
            $this->createLog('修改'.$title.'：<code>'.$field.'</code>', 3);
        }
    }

    private function createLog($txt, $type=1) {
        $html = '';
        $html .= '<div>';
        if ($type == 2) $html .= '<span class="level2"></span>';
        if ($type == 3) $html .= '<span class="level3"></span>';
        if ($type == 4) $html .= '<span class="level4"></span>';
        $html .= $txt;
        $html .= '</div>';
        $this->content .= $html;
    }
}