<?php

namespace app\http\api\item;
use x\controller\Http;
use x\Restful;

class insert extends Http
{
    /**
     * @Post
     * @Param(name="title", empty="true", tips="请输入项目名称")
     * @Param(name="domain_id", empty="true", tips="请先选择默认根域名")
     * @Param(name="return_id", empty="true", tips="请先选择默认返回结构")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $info = $this->Db->name('item')->where('title', $param['title'])->find();
        if ($info) {
            return Restful::code(Restful::ERROR())->setMsg('该项目名称已存在')->callback();
        }

        $param['create_time'] = time();
        $param['update_time'] = time();
        $param['title'] = $param['title'];
        $param['version'] = !empty($param['version']) ? $param['version'] : 'v1.0.1'; 
        $param['des'] = $param['des'];
        $param['domain_id'] = $param['domain_id'];
        $param['return_id'] = $param['return_id'];
        $param['is_var'] = $param['is_var'];
        $param['pwd'] = $param['pwd'];
        $param['content'] = $param['content'];
        $param['doc_id'] = md5($param['create_time'].$param['title']);
        $param['domain_list'] = $param['domain_list'] ?? '';
        $param['status'] = $param['status'] ?? 2; 
        $file = \x\Request::file();
        if (!empty($file['cover_file'])) {
            $file = $this->file('cover_file');
            $info = $file->validate(['size'=>1024*1024*2, 'ext'=>'jpg,jpeg,png,gif'])->move(ROOT_PATH.'/public/uploads');
            if($info){
                $param['cover_file'] = str_replace(ROOT_PATH.'/public', '', $info->getSaveName());
            }else{
                return Restful::code(Restful::ERROR())->setMsg($file->getError())->callback();
            }
        }
        if (isset($param['cover_file']) && $param['cover_file'] == 'undefined') unset($param['cover_file']);
        $item_id = $this->Db->name('item')->insertGetId($param);
        if ($item_id) {
            $this->Db->name('api_group')->insert([
                'item_id' => $item_id,
                'title' => '默认分组',
                'des' => '由系统自动创建',
                'create_time' => time(),
            ]);
            return Restful::code(Restful::SUCCESS())->setMsg('项目创建成功')->callback();
        }	
        return Restful::code(Restful::ERROR())->setMsg('项目创建失败')->callback();
    }
}