<?php

namespace app\http\api\item;
use x\controller\Http;
use x\Restful;

class update extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="title", empty="true", tips="请输入项目名称")
     * @Param(name="domain_id", empty="true", tips="请先选择默认根域名")
     * @Param(name="return_id", empty="true", tips="请先选择默认返回结构")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $info = $this->Db->name('item')->where('title', $param['title'])->where('id', '<>', $param['id'])->find();
        if ($info) {
            return Restful::code(Restful::ERROR())->setMsg('该项目名称已存在')->callback();
        }
        $data = [];
        $data['update_time'] = time();
        $data['title'] = $param['title'];
        $data['version'] = $param['version'];
        $data['des'] = $param['des'];
        $data['domain_id'] = $param['domain_id'];
        $data['return_id'] = $param['return_id'];
        $data['is_var'] = $param['is_var'];
        $data['pwd'] = $param['pwd'];
        $data['content'] = $param['content'];
        $param['domain_list'] = $param['domain_list'] ?? '';
        $param['status'] = $param['status'] ?? 2; 
        $file = \x\Request::file();
        if (!empty($file['cover_file'])) {
            $file = $this->file('cover_file');
            $info = $file->validate(['size'=>1024*1024*2, 'ext'=>'jpg,jpeg,png,gif'])->move(ROOT_PATH.'/public/uploads');
            if($info){
                $param['cover_file'] = str_replace(ROOT_PATH.'/public', '', $info->getSaveName());
            }else{
                return Restful::code(Restful::ERROR())->setMsg($file->getError())->callback();
            }
        }
        if (isset($param['cover_file']) && $param['cover_file'] == 'undefined') unset($param['cover_file']);
        $res = $this->Db->name('item')->where('id', $param['id'])->update($param);
        if ($res === false) {
            return Restful::code(Restful::ERROR())->setMsg('项目修改失败')->callback();
        }
        return Restful::code(Restful::SUCCESS())->setMsg('项目修改成功')->callback();
    }
}