<?php

namespace app\http\api\returns;
use x\controller\Http;
use x\Restful;

class update extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="title", empty="true", tips="请输入结构名称")
     * @Param(name="list", empty="true", tips="请创建参数结构")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $is_code = false;
        $is_data = false;
        foreach ($param['list'] as $v) {
            if (empty($v['field'])) {
                return Restful::code(Restful::ERROR())->setMsg('字段名不能为空')->callback();
            }
            if (isset($v['is_code']) && $v['is_code'] == 1) {
                if ($is_code == true) {
                    return Restful::code(Restful::ERROR())->setMsg('为Code条件的字段只能存在一个')->callback();
                }
                $is_code = true;
            }
            if (isset($v['is_data']) && $v['is_data'] == 1) {
                if ($is_data == true) {
                    return Restful::code(Restful::ERROR())->setMsg('为Data返回值的字段只能存在一个')->callback();
                }
                $is_data = true;
            }
        }
        if ($is_code == false) {
            return Restful::code(Restful::ERROR())->setMsg('请先选择为Code条件的字段')->callback();
        }
        if ($is_data == false) {
            return Restful::code(Restful::ERROR())->setMsg('请先选择为Data返回值的字段')->callback();
        }
        $data = [];
        $data['update_time'] = time();
        $data['title'] = $param['title'];
        $data['return_type'] = $param['return_type'];

        $res = $this->Db->name('return')->where('id', $param['id'])->update($data);
        if ($res) {
            $this->Db->name('return_field')->where('pid', $param['id'])->delete();
            foreach ($param['list'] as $k=>$v) {
                if (!isset($v['is_code'])) $v['is_code'] = 0;
                if (!isset($v['is_data'])) $v['is_data'] = 0;
                $v['pid'] = $param['id'];
                $v['sort'] = $k;
                $this->Db->name('return_field')->insert($v);
            }
            return Restful::code(Restful::SUCCESS())->setMsg('返回结构修改成功')->callback();
        }	
        return Restful::code(Restful::ERROR())->setMsg('返回结构修改失败')->callback();
    }
}