<?php
namespace app\http\apidoc;
use x\controller\Http;
use x\Restful;
use x\Cookie;

class curl_send extends Http
{
    private $body_param = [];

    /**
     * @Post
     * @Param(name="curl_url", empty="true", tips="请输入请求地址")
    */
    public function index() {
        $param = \x\Request::post();

        $body_param = [];
        if (!empty($param['param'])) {
            $this->body_insert($param['param']);
            $body = $this->recursion($this->body_param);
            foreach ($body as $v) {
				if (!empty($v['list'])) {
					$body_param[$v['field']] = $this->recursion2($v['list']);
				} else {
					$body_param[$v['field']] = $v['value'];
				}
            }
        }
        
        $request_param = [];
        if (!empty($param['request'])) {
			foreach ($param['request'] as $v) {
				$request_param[$v['field']] = $v['value'];
			}
        }
        
        $param_type = $param['curl_mode'];
        if ($param_type == 2) {
			$body_param = json_encode($body_param);
			$request_param['Content-Type'] = 'application/json; charset=utf-8';
			$request_param['Content-Length'] = strlen($body_param);
		} else if ($param_type == 3) {
			$request_param['Content-Type'] = 'text/xml; charset=utf-8';
			$body_param = Tool::array2Xml($body_param);
        }

        $api_url = $param['curl_url'];
        
        $httpClient = new \x\Client();
        $http = $httpClient->http()
                ->domain($api_url)
                ->set([
                    'timeout' => 20
                ])
                ->setHeaders($request_param)
                ->body($body_param?:array());
                
        if (!empty($param['cookie'])) {
            $http->setCookies($param['cookie']);
        }
        if ($param['curl_type'] == 2) {
            $http->setMethod('POST');   
            $body = $http->post();
        } else {
            $body = $http->get();
        }

        $responseHead = $http->getHeaders();
        if (is_array($responseHead)) $responseHead = json_encode($responseHead, JSON_UNESCAPED_UNICODE);
        if (is_array($body)) $body = json_encode($body, JSON_UNESCAPED_UNICODE);

        
        return Restful::code(Restful::SUCCESS())->setMsg('请求完成')->data([
            'header' => $responseHead,
            'body' => $body
        ])->callback();
    }

    public function body_insert($list, $pid=0) {
        foreach ($list as $v) {
            $cid = uniqid();
            $this->body_param[] = [
                'id' => $cid,
                'pid' => $pid,
                'field' => $v['field'],
                'value' => $v['value'],
            ];
            foreach ($v as $val) {
                if (is_array($val)) {
                    $this->body_insert([$val], $cid);
                }
            }
        }
    }
    public function recursion($array='', $field1='id', $field2='pid', $menu = 'list', $pid = 0) {
        $arr = [];
        foreach ($array as $v) {
            if ($v[$field2] == $pid) {
                $v[$menu] = $this->recursion($array, $field1, $field2, $menu, $v[$field1]);
                $arr[] = $v;
            }
        }
        return $arr;
    }
    public function recursion2($array=[]) {
        $arr = [];
        foreach ($array as $v) {
			if (!empty($v['list'])) {
				$arr[$v['field']] = $this->recursion2($v['list']);
			} else {
				$arr[$v['field']] = $v['value'];
			}
        }
        return $arr;
    }
}