<?php

namespace app\http\apidoc;
use x\controller\Http;
use x\Cookie;

class index extends Http
{

    /**
     * @RequestMapping(route="/apidoc", method="GET", title="API文档查看主页")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function run() {
        $param = \x\Request::get();
        if (empty($param['token'])) return $this->fetch('NO~');
        $info = $this->Db->name('item')->where('doc_id', $param['token'])->find();
        if (!$info) return $this->fetch('NO~');
        $item_id = $info['id'];

        $this->assign('param', $param);
        $this->assign('item', $info);
        $this->assign('token', $param['token']);

        $domain_id = !empty($info['domain_list']) ? $info['domain_list'] : 0;
        $domain = $this->Db->name('domain')->whereIn('id', '('.$domain_id.')')->field('title, domain')->select();
        $this->assign('domain', $domain);

        if (!Cookie::get($param['token']) && !empty($info['pwd'])) {
            $this->assign('havior', \x\verify\Havior::create('shop_havior'));
            return $this->display('apidoc/login');
        }

        $info = $this->Db->name('api_group')->where('item_id', $info['id'])->order('sort DESC, id ASC')->field('id, title')->select();
        foreach ($info as $k => $v) {
            $info[$k]['list'] = $this->Db->name('api')->where('group_id', $v['id'])->where('display', 1)->order('sort ASC')->field('id, title, request_type')->select();
        }
        $this->assign('api', $info);
        
        $this->assign('var_list', $this->Db->name('test_variable')->order('id ASC')->select());

        $this->assign('fun_list', $this->Db->name('test_function')->order('id ASC')->select());
        
        $this->assign('version_list', $this->Db->name('version_log')->where('item_id', $item_id)->order('id DESC')->select());

        return $this->display('apidoc/index');
    }
}