<?php

namespace app\http\apidoc;
use x\controller\Http;
use x\Restful;
use x\Cookie;

class info extends Http
{
    /**
     * @Post
     * @Param(name="token", empty="true", tips="缺少文档标识符")
     * @Param(name="id", empty="true", tips="请输入接口ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $item = $this->Db->name('item')->where('doc_id', $param['token'])->find();
        if (!$item) return Restful::code(Restful::ERROR())->setMsg('非法请求')->callback();
        if ($item['pwd'] && empty(Cookie::get($param['token']))) {
            return Restful::code(Restful::ERROR())->setMsg('您尚未登入账号，请先登录')->callback();
        }

        if ($param['id'] == 'word') {
            return Restful::code(Restful::SUCCESS())->setMsg('读取成功')->data([
                'content' => $item['content']
            ])->callback();
        } else if ($param['id'] == 'code') {
            $code = $this->Db->name('api')->alias('A')
                    ->join('api_return_code B', 'A.id = B.api_id')
                    ->where('A.item_id', $item['id'])
                    ->where('A.display', 1)
                    ->where('B.code', '<>', "")
                    ->order('B.code ASC')
                    ->group('B.code')
                    ->field('B.*')
                    ->select();
            if (count($code) == 1) {
                if ($code[0]['api_id'] === null) {
                    $code = []; 
                }
            }
            foreach ($code as $k => $v) {
                $code[$k]['param_type'] = type_list($v['param_type']);
            }
            return Restful::code(Restful::SUCCESS())->setMsg('读取成功')->data($code)->callback();
        } 

        $return = $this->Db->name('api')->where('display', 1)->where('id', $param['id'])->find();
        if (!$return) {
            return Restful::code(Restful::ERROR())->setMsg('接口信息读取失败')->callback();
        }
        $return['host_url2'] = \x\Request::domain().$return['imitate_route'];

        $return['type'] = request_list($return['request_type']);
        $return['param'] = param_list($return['param_type']);

        $return['group'] = $this->Db->name('api_group')->where('id', $return['group_id'])->value('title');

        $return['status'] = $this->Db->name('status')->where('id', $return['status'])->find();
        $return['update_time'] = formatTime($return['update_time']);

        if ($return['domain_id']) {
            $res = $this->Db->name('domain')->where('id', $return['domain_id'])->find();
        } else {
            $res = $this->Db->name('domain')->where('id', $item['domain_id'])->find();
        }
        $return['host_url'] = $res['domain'].$return['host_url'];
        if (stripos($res['domain'], 'https') !== false) {
            $return['http'] = 'HTTPS';
        } else {
            $return['http'] = 'HTTP';
        }
        if ($return['return_id']) {
            $res = $this->Db->name('return')->where('id', $return['return_id'])->find();
        } else {
            $res = $this->Db->name('return')->where('id', $item['return_id'])->find();
        }
        $return['return_type'] = param_list($res['return_type']);

        $return['return_field'] = $this->Db->name('return_field')->where('pid', $res['id'])->order('sort ASC')->select();
        
        $return['success_list'] = $this->Db->name('api_success')->where('api_id', $param['id'])->select();
        $return['error_list'] = $this->Db->name('api_error')->where('api_id', $param['id'])->select();

        $request = $this->Db->name('api_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        foreach ($request as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $request[$k] = $v;
        }
        $return['request'] = $request;

        $return_request = $this->Db->name('api_return_request')->where('api_id', $param['id'])->order('sort ASC')->select();
        foreach ($return_request as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $return_request[$k] = $v;
        }
        $return['return_request'] = $return_request;

        $return_code = $this->Db->name('api_return_code')->where('api_id', $param['id'])->select();
        foreach ($return_code as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $return_code[$k] = $v;
        }
        $return['return_code'] = $return_code;

        $list = $this->Db->name('api_body')->where('api_id', $param['id'])->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $list[$k] = $v;
        }
        $return['body'] = $this->recursion($list);

        $list = $this->Db->name('api_return')->where('api_id', $param['id'])->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $v['param_type'] = type_list($v['param_type']);
            $list[$k] = $v;
        }
        $return['return'] = $this->recursion($list);

        $usecase_list = $this->Db->name('test_usecase_group')->where('api_id', $param['id'])->order('sort DESC, id DESC')->field('id, title')->select();
        foreach ($usecase_list as $k => $v) {
            $usecase_list[$k]['list'] = $this->Db->name('test_usecase')->where('group_id', $v['id'])->order('id ASC')->field('id, title')->select();
        }
        $return['usecase_list'] = $usecase_list;

        return Restful::code(Restful::SUCCESS())->setMsg('读取成功')->data($return)->callback();
    }

    public function recursion($array='', $field1='id', $field2='pid', $menu = 'list', $pid = 0) {
        $arr = [];
        foreach ($array as $v) {
            if ($v[$field2] == $pid) {
                $v[$menu] = $this->recursion($array, $field1, $field2, $menu, $v[$field1]);
                $arr[] = $v;
            }
        }
        return $arr;
    }
}