<?php

namespace app\http\apidoc;
use x\controller\Http;
use x\Restful;
use x\Cookie;

class ordinary_ut extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="缺少用例ID")
     * @Param(name="token", empty="true", tips="缺少文档标识符")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();

        $item = $this->Db->name('item')->where('doc_id', $param['token'])->find();
        if (!$item) return Restful::code(Restful::ERROR())->setMsg('非法请求')->callback();
        if ($item['pwd'] && empty(Cookie::get($param['token']))) {
            return Restful::code(Restful::ERROR())->setMsg('您尚未登入账号，请先登录')->callback();
        }

		$obj = new \Task\Ut();
        $res = $obj->run($param['id']);
        $res['request_type'] = request_list($res['request_type']);
        $res['param_type'] = param_list($res['param_type']);
        return Restful::code(Restful::SUCCESS())->setMsg('执行成功')->data($res)->callback();
    }
}