<?php
namespace app\http\apidoc;
use x\controller\Http;
use x\Restful;
use x\Cookie;

class version_info extends Http
{
    /**
     * @Post
     * @Param(name="token", empty="true", tips="缺少文档标识符")
     * @Param(name="id", empty="true", tips="请输入版本ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $item = $this->Db->name('item')->where('doc_id', $param['token'])->find();
        if (!$item) return Restful::code(Restful::ERROR())->setMsg('非法请求')->callback();
        if ($item['pwd'] && empty(Cookie::get($param['token']))) {
            return Restful::code(Restful::ERROR())->setMsg('您尚未登入账号，请先登录')->callback();
        }

        $html = $this->Db->name('version_log')->where('id', $param['id'])->value('content');

        return Restful::code(Restful::SUCCESS())->setMsg('读取成功')->data($html)->callback();
    }
}

