<?php

namespace app\http\auth\admin;
use x\controller\Http;
use x\Restful;

class info extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();

        $res = $this->Db->name('auth_admin')->where('id', $param['id'])->find();
        if (!$res) {
            return Restful::code(Restful::ERROR())->setMsg('账号信息读取失败')->callback();
        }
        $res['update_time'] = date('Y-m-d H:i:s', $res['update_time']);

        if ($res['role_id'] == 0) {
            $menu = $this->Db->name('auth_menu')->where('status', 1)->order('id ASC')->field('id, pid, menu_name as name')->select();
        } else {
            $id = $this->Db->name('auth_role')->where('id', $res['role_id'])->value('menu_list');
            $menu = $this->Db->name('auth_menu')->whereIn('id', '('.$id.')')->order('id ASC')->field('id, pid, menu_name as name')->select();
        }

        $res['menu'] = $this->menu_make($menu);

        return Restful::code(Restful::SUCCESS())->setMsg('账号信息读取完成')->data($res)->callback();
    }

    private function menu_make($cate=[], $name = 'children', $pid = 0) {
        $arr = [];
        foreach ($cate as $v) {
            if ($v['pid'] == $pid) {
                $v[$name] = self::menu_make($cate, $name, $v['id']);
                $arr[$v['name']] = ['additionalParameters'=>$v];
                $arr[$v['name']]['name'] = $v['name'];
                $arr[$v['name']]['type'] = 'folder';
                $arr[$v['name']]['item-selected'] = true;
            }
        }
        return $arr;
    }
}