<?php
namespace app\http\auth\admin;
use x\controller\Http;
use x\Restful;

class update extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="username", alias="账号", validate="min:4|max:20")
     * @Param(name="password", alias="密码", validate="password:5,12")
     * @Param(name="phone", alias="手机号", validate="phone")
     * @Param(name="email", alias="邮箱", validate="email")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $info = $this->Db->name('auth_admin')->where('id', $param['id'])->find();
        if (!empty($param['password'])) {
            $param['password'] = md5($param['password'].$info['create_time']);
        }
        $param['update_time'] = time();

        if ($info['role_id'] == 0 && $param['role_id'] != 0) {
            $num = $this->Db->name('auth_admin')->where('role_id', 0)->count();
            if ($num == 1) {
                return Restful::code(Restful::ERROR())->setMsg('禁止修改该身份，系统必须保留至少一位超级账号')->callback();
            }
        }

        if ($info['status'] == 1 && $param['status'] != 1) {
            $num = $this->Db->name('auth_admin')->where('role_id', 0)->count();
            if ($num == 1) {
                return Restful::code(Restful::ERROR())->setMsg('不允许禁用该账号，系统必须保留至少一位超级账号')->callback();
            }
        }

        $res = $this->Db->name('auth_admin')->where('id', $param['id'])->update($param);
        if ($res === false) {
            return Restful::code(Restful::ERROR())->setMsg('账号修改失败')->callback();
        }
        return Restful::code(Restful::SUCCESS())->setMsg('账号修改成功')->callback();
    }
}