<?php

namespace app\http\auth\menu;
use x\controller\Http;
use x\Restful;

class insert extends Http
{
    /**
     * @Post
     * @Param(name="menu_name", empty="true", tips="请输入菜单名称")
     * @Param(name="route", empty="true", tips="请输入路由")
     * @Param(name="pid", empty="true", tips="缺少上级ID参数")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $info = $this->Db->name('auth_menu')->where('route', $param['route'])->find();
        if ($info) {
            return Restful::code(Restful::ERROR())->setMsg('该路由已重复')->callback();
        }
        $param['update_time'] = time();
        $id = $this->Db->name('auth_menu')->insertGetId($param);
        if ($id === false) {
            return Restful::code(Restful::ERROR())->setMsg('权限菜单创建失败')->callback();
        }
        if ($param['pid'] == 0) {
            $this->Db->name('auth_menu')->where('id', $id)->update(['path' => $id]);
        } else {
            $path = $this->Db->name('auth_menu')->where('id', $param['pid'])->value('path');
            $this->Db->name('auth_menu')->where('id', $id)->update(['path' => $path.'/'.$id]);
        }
        return Restful::code(Restful::SUCCESS())->setMsg('权限菜单创建成功')->callback();
    }
}