<?php

namespace app\http\robot;
use x\controller\Http;
use Robot\RobotTool;

class logic extends Http
{
    private $info = [
        'title' => '标题', 
        'tt_title' => '内容', 
    ];

    /**
     * @RequestMapping(route="/robot/logic")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();

        $key = $param['key'];
        $key = strtolower(trim($key));
        
        $info = $this->algorithm_1($key);
        if ($info) {
            return $this->fetch(json_encode(['code'=>'00','msg'=>'获得答案','data'=>$info]));
        }
        return $this->fetch(json_encode(['code'=>'02','msg'=>'(>﹏<)~~ 暂时没有收录到该问题的答案，很抱歉!']));
    }

    public function algorithm_1($key) {
        $str_arr1 = RobotTool::CharToArr($key);

        if (strpos($key, "'")) {$where='title like "%'.$key.'%"';}else{$where="title like '%".$key."%'";}
        $list = $this->Db->name('robot_data')->where($where)->field('id, title, 0 as num')->order('id desc')->select();

        if ($list) {
            foreach ($list as $k => $value) {
                $str_arr2 = RobotTool::CharToArr($value['title']);
                $list[$k]['lcs'] = RobotTool::S($str_arr1, $str_arr2);
            }
        } else {
            $obj = new \Robot\phpcutting\Phpcutting();
            $fenci = $obj->run($key);
       
            $where = '';
            foreach ($fenci['en'] as $v){
                if (strpos($v, "'") !== false) {$w=' title like "%'.$v.'%" OR';}else{$w=" title like '%".$v."%' OR";}
                $where .= $w;
            }
            foreach ($fenci['zh'] as $v){
                if (strpos($v, "'") !== false) {$w=' title like "%'.$v.'%" OR';}else{$w=" title like '%".$v."%' OR";}
                $where .= $w;
            }
            $where = ltrim(rtrim(rtrim($where, 'OR'),' '),' ');
            $list = $this->Db->name('robot_data')->where($where)->field('id, title, 0 as num')->order('id desc')->select();
    
            foreach ($list as $k => $value) {
                $str_arr2 = RobotTool::CharToArr($value['title']);
                $list[$k]['lcs'] = RobotTool::S($str_arr1, $str_arr2);
                foreach ($fenci['en'] as $v){
                    if (stripos($value['title'], $v) !== false) {
                        $obj->record($v);
                        $list[$k]['num']++;
                    }
                }
            }
            foreach ($list as $k => $value) {
                $str_arr2 = RobotTool::CharToArr($value['title']);
                $list[$k]['lcs'] = RobotTool::S($str_arr1, $str_arr2);
                foreach ($fenci['zh'] as $v){
                    if (stripos($value['title'], $v) !== false) {
                        $obj->record($v);
                        $list[$k]['num']++;
                    }
                }
            }
        }

        if ($list) {
            $list = RobotTool::array_sort($list);
            $last_names = array_column($list,'lcs');
            array_multisort($last_names,SORT_DESC,$list);
            $last_names = array_column($list,'num');
            array_multisort($last_names,SORT_DESC,$list);
            
            $info = $list[0];
            $this->Db->name('robot_data')->where('id ='.$info['id'])->setInc('num');
            $info = $this->Db->name('robot_data')->where('id ='.$info['id'])->field('title, content as tt_title')->find();

            return $info;
        }

        return false;
    }
}