<?php

namespace app\http\test\fun;
use x\controller\Http;
use x\Restful;

class update extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="name", empty="true", tips="请输入函数名称", alias="函数名称", validate="username:2,12")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $res = $this->Db->name('test_function')->where('name', $param['name'])->where('id', '<>', $param['id'])->find();
        if ($res) return Restful::code(Restful::ERROR())->setMsg('该函数名称已被使用')->callback();

        $info = $this->Db->name('test_function')->where('id', $param['id'])->find();
        if ($info['name'] != $param['name']) {
            if (function_exists($param['name'])) {
                return Restful::code(Restful::ERROR())->setMsg('该函数名称已被系统使用')->callback();
            }
        }

        $res = $this->Db->name('test_function')->where('id', $param['id'])->update($param);
        if ($res === false) return Restful::code(Restful::ERROR())->setMsg('全局函数修改失败')->callback();
        if ($info['name'] != $param['name']) {
            $idJson = file_get_contents(\x\Config::get('server.pid_file'));  
            $idArray = json_decode($idJson, true);
            posix_kill($idArray['manager_pid'], SIGUSR1);
        }
        return Restful::code(Restful::SUCCESS())->setMsg('全局函数修改成功')->callback();
    }
}