<?php

namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class ab_chat extends Http
{
    /**
     * @Post
     * @Param(name="ab_id", empty="true", tips="缺少任务ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $info = $this->Db->name('test_ab')->where('id', $param['ab_id'])->find();
        if (!$info) {
            return Restful::code(Restful::ERROR())->setMsg('任务已被删除')->callback();
        }
        $date = [];
        $data = [];

        if (!$info['duration']) {
            $list = $this->Db->name('test_ab_log')->where('ab_id', $param['ab_id'])->order('time ASC')->field('ms, time')->select();
        } else {
            $sql = $this->Db->name('test_ab_log')->where('ab_id', $param['ab_id'])->order('time ASC, ms DESC')->field('ms, time')->buildSql();
            $list = $this->Db->table($sql.' AS A')->group('A.time')->select();
        }
        foreach ($list as $v) {
            $date[] = date('H:i:s', $v['time']);
            $data[] = $v['ms'];
        }

        return Restful::code(Restful::SUCCESS())->data([
            'date' => $date,
            'data' => $data,
            'SQL' => $list
        ])->setMsg('获取成功')->callback();
    }
}