<?php

namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class ab_create extends Http
{
    /**
     * @Post
     * @Param(name="usecase_id", empty="true", tips="缺少用例ID")
     * @Param(name="thread_num", empty="true", tips="请输入并发数")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $res = $this->Db->name('test_usecase')->where('id', $param['usecase_id'])->field('id')->select();
        if (!$res) {
            return Restful::code(Restful::ERROR())->setMsg('该用例已被删除，无法创建压力测试任务')->callback();
        }
        $go_time = !empty($param['go_time']) ? strtotime($param['go_time']) : 0;
        if ($go_time > 0 && $go_time <= time()) {
            return Restful::code(Restful::ERROR())->setMsg('任务启动时间，不能设置为过去日期')->callback();
        } 
        if (filter_var($param['thread_num'], FILTER_VALIDATE_INT) == false || $param['thread_num'] <= 0) return Restful::code(Restful::ERROR())->setMsg('并发数格式错误，只能为整数')->callback();
        $cpu = swoole_cpu_num();
        $cpu_num = $cpu*120;
        if ($param['thread_num'] > $cpu_num) {
            return Restful::code(Restful::ERROR())->setMsg('并发数不能大于'.$cpu_num.'，当前机器'.$cpu.'核，单核只能支持120并发测试')->callback();
        }

        if (!empty($param['ramp_up'])) {
            if (filter_var($param['ramp_up'], FILTER_VALIDATE_INT) == false || $param['ramp_up'] <= 0) return Restful::code(Restful::ERROR())->setMsg('Ramp_up格式错误，只能为整数')->callback();
            if ($param['ramp_up'] > $param['thread_num']) {
                return Restful::code(Restful::ERROR())->setMsg('Ramp_up 不能等于 并发数')->callback();
            }
            $b = floor($param['thread_num'] / $param['ramp_up']);
            if ($b < 1) {
                return Restful::code(Restful::ERROR())->setMsg('并发数除以Ramp_up的倍数不能小于1')->callback();
            }
        }
        if (!empty($param['for_num'])) {
            if (filter_var($param['for_num'], FILTER_VALIDATE_INT) == false || $param['for_num'] <= 0) return Restful::code(Restful::ERROR())->setMsg('循环次数格式错误，只能为整数')->callback();
        }
        if (!empty($param['duration'])) {
            if (filter_var($param['duration'], FILTER_VALIDATE_INT) == false || $param['duration'] <= 0) return Restful::code(Restful::ERROR())->setMsg('持续时间格式错误，只能为整数')->callback();
        }
        $admin = \x\Session::get('admin');
        $usecase_id = $param['usecase_id'];
       
        $info = $this->Db->name('test_usecase')->where('id', $usecase_id)->field('item_id, api_id, title')->find();
        $ab_id = $this->Db->name('test_ab')->insertGetId([
            'usecase_id' => $usecase_id,
            'item_id' => $info['item_id'],
            'api_id' => $info['api_id'],
            'title' => !empty($param['title']) ? $param['title'] : '用例['.$info['title'].']的压测任务',
            'thread_num' => $param['thread_num'],
            'ramp_up' => $param['ramp_up'],
            'for_num' => $param['for_num'],
            'duration' => $param['duration'],
            'go_time' => $go_time,
            'create_time' => time(),
            'admin_id' => $admin['id'],
        ]);
        if (!$ab_id) {
            return Restful::code(Restful::ERROR())->setMsg('压力测试任务创建失败')->callback();
        }

        if ($go_time > 0) {
            $s = $go_time-time();
        } else {
            $s = 1;
        }
        $time = $s*1000;

        $time_id = \Swoole\Timer::after($time, function() use($usecase_id, $ab_id) {
            $Curl = new \Task\Ab();
            $Curl->run($usecase_id, $ab_id);
        });

        $this->Db->name('test_ab')->where('id', $ab_id)->update([
            'time_id' => $time_id
        ]);
        
        return Restful::code(Restful::SUCCESS())->setMsg('执行成功，测试结果：在侧栏【压力测试】菜单中查看')->callback();
    }
}