<?php

namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class ab_list extends Http
{
    /**
     * @Post
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $where = [];
        if (!empty($param['item_id'])) {
            $where[] = ['A.item_id', '=', $param['item_id']];
        }
        if (!empty($param['api_id'])) {
            $where[] = ['A.api_id', '=', $param['api_id']];
        }
        $total = $this->Db->name('test_ab')->alias('A')
                ->join('item B', 'A.item_id=B.id')
                ->join('api C', 'A.api_id=C.id')
                ->join('test_usecase D', 'A.usecase_id=D.id')
                ->order('A.id DESC')
                ->where($where)
                ->count();
        $list = $this->Db->name('test_ab')->alias('A')
                ->join('item B', 'A.item_id=B.id')
                ->join('api C', 'A.api_id=C.id')
                ->join('test_usecase D', 'A.usecase_id=D.id')
                ->join('auth_admin E', 'A.admin_id=E.id')
                ->order('A.id DESC')
                ->where($where)
                ->field('A.*, B.title as item_title, C.title as api_title, D.title as usecase_title, E.fullname')
                ->page($param['page'], 20)
                ->select();
        foreach ($list as $k => $v) {
            $list[$k]['start_time'] = formatTime($v['start_time']);
            if (!$v['end_time']) {
                $list[$k]['end_time'] = '运行中';
            } else {
                $list[$k]['end_time'] = formatTime($v['end_time']);
            }
            if (!$v['go_time']) {
                $list[$k]['go_time'] = ' ';
            } else {
                $list[$k]['go_time'] = date('Y-m-d H:i:s', $v['go_time']);
            }
            
        }
        if ($total == 0) {
            $page = 1;
        } else {
            $page = ceil($total/20);
        }
        
        $status = false;
        if ($param['page'] != $page) {
            $status = true;
        }

        return Restful::code(Restful::SUCCESS())->data([
            'page' => $status,
            'data' => $list
        ])->setMsg('获取成功')->callback();
    }
}