<?php


namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class at_list extends Http
{
    /**
     * @Post
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $where = [];
        $total = $this->Db->name('test_template')
                ->order('id DESC')
                ->where($where)
                ->count();
        $list = $this->Db->name('test_template')
                ->order('id DESC')
                ->where($where)
                ->page($param['page'], 20)
                ->select();
        foreach ($list as $k => $v) {
            $list[$k]['create_time'] = formatTime($v['create_time']);
            if (!$v['update_time']) {
                $list[$k]['update_time'] = ' ';
            } else {
                $list[$k]['update_time'] = formatTime($v['update_time']);
            }
            if (!$v['depth']) {
                $list[$k]['depth'] = '0';
            }
            if (!$v['des']) {
                $list[$k]['des'] = ' ';
            }
        }
        if ($total == 0) {
            $page = 1;
        } else {
            $page = ceil($total/20);
        }
        
        $status = false;
        if ($param['page'] != $page) {
            $status = true;
        }

        return Restful::code(Restful::SUCCESS())->data([
            'page' => $status,
            'data' => $list
        ])->setMsg('获取成功')->callback();
    }
}