<?php
namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class copy extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        
        if (!empty($param['group_id'])) {
            $arr = explode(',', $param['group_id']);
            foreach ($arr as $key => $group_id) {
                $this->copy_one($param['id'], $group_id);
            }
        } else {
            $info = $this->Db->name('test_usecase')->where('id', $param['id'])->find();
            if (!$info) {
                return Restful::code(Restful::ERROR())->setMsg('该用例已被删除')->callback();
            }
            $group_id = $info['group_id'];
            $this->copy_one($param['id'], $group_id);
        }

        return Restful::code(Restful::SUCCESS())->setMsg('用例复制成功')->callback();
    }

    private function copy_one($usecase_id, $group_id) {
        $info = $this->Db->name('test_usecase')->where('id', $usecase_id)->find();
        unset($info['id']);
        $res = $this->Db->name('test_usecase')->where('id', '<>', $usecase_id)->where('group_id', $group_id)->where('title', $info['title'])->value('id');
        if ($res) $info['title'] .= '（副本）';
        $info['group_id'] = $group_id;

        $code = $this->Db->name('test_usecase_code')->where('usecase_id', $usecase_id)->select();
        $body = $this->Db->name('test_usecase_param')->where('usecase_id', $usecase_id)->where('pid=0')->select();
        $request = $this->Db->name('test_usecase_request')->where('usecase_id', $usecase_id)->select();

        $usecase_id = $this->Db->name('test_usecase')->insertGetId($info);
        foreach ($code as $v) {
            $v['usecase_id'] = $usecase_id;
            $this->Db->name('test_usecase_code')->insert($v);
        }
        foreach ($request as $v) {
            $v['usecase_id'] = $usecase_id;
            $this->Db->name('test_usecase_request')->insert($v);
        }

        $this->body_insert($body, $usecase_id, 0);

        return true;
    }

    private function body_insert($list, $usecase_id, $pid=0) {
        foreach ($list as $v) {
            $arr = $this->Db->name('test_usecase_param')->where('pid', $v['id'])->select();
            unset($v['id']);
            $v['pid'] = $pid;
            $v['usecase_id'] = $usecase_id;
            $id= $this->Db->name('test_usecase_param')->insertGetId($v);
            if ($arr) {
                $this->body_insert($arr, $usecase_id, $id);
            }
        }
    }
}