<?php

namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class info extends Http
{
    /**
     * @Post
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        if (empty($param['id']) && empty($param['api_id'])) {
            return Restful::code(Restful::ERROR())->setMsg('缺少参数')->callback();
        }
        if (!empty($param['id'])) {
            $info = $this->Db->name('test_usecase')->where('id', $param['id'])->find();
            $info['request_list'] = $this->Db->name('api_request')->where('api_id', $info['api_id'])->order('sort ASC')->select();
            $info['return_request_list'] = $this->Db->name('api_return_request')->where('api_id', $info['api_id'])->order('sort ASC')->select();
            $info['return_code_list'] = $this->Db->name('api_return_code')->where('api_id', $info['api_id'])->order('sort ASC')->select();
            $list = $this->Db->name('api_body')->where('api_id', $info['api_id'])->order('id ASC')->select();
            $info['body_list'] = $this->recursion($list);

            $info['usecase_request_list'] = $this->Db->name('test_usecase_request')->where('usecase_id', $info['id'])->select();
            $info['usecase_code_list'] = $this->Db->name('test_usecase_code')->where('usecase_id', $info['id'])->select();
            $list = $this->Db->name('test_usecase_param')->where('usecase_id', $info['id'])->order('id ASC')->select();
            $info['usecase_body_list'] = $this->recursion($list);
        } else {
            $info = [];
            $info['request_list'] = $this->Db->name('api_request')->where('api_id', $param['api_id'])->order('sort ASC')->select();
            $info['return_request_list'] = $this->Db->name('api_return_request')->where('api_id', $param['api_id'])->order('sort ASC')->select();
            $info['return_code_list'] = $this->Db->name('api_return_code')->where('api_id', $param['api_id'])->order('sort ASC')->select();
            $list = $this->Db->name('api_body')->where('api_id', $param['api_id'])->order('id ASC')->select();
            $info['body_list'] = $this->recursion($list);
        }
        
        return Restful::code(Restful::SUCCESS())->setMsg('获取成功')->data($info)->callback();
    }

    public function recursion($array='', $field1='id', $field2='pid', $menu = 'list', $pid = 0) {
        $arr = [];
        foreach ($array as $v) {
            if ($v[$field2] == $pid) {
                $v[$menu] = $this->recursion($array, $field1, $field2, $menu, $v[$field1]);
                $arr[] = $v;
            }
        }
        return $arr;
    }
}