<?php

namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class task_index extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="缺少模板ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
       
        $list = $this->Db->name('task')->alias('A')
                ->join('test_template B', 'A.template_id=B.id')
                ->order('A.id DESC')
                ->field('A.*, B.title')
                ->where('template_id', $param['id'])
                ->select();

        foreach ($list as $k=>$v) {
            $list[$k]['start_time'] = date('Y-m-d H:i:s', $v['start_time']);
            $list[$k]['create_time'] = date('Y-m-d H:i:s', $v['create_time']);
            $list[$k]['task_start_time'] = $v['task_start_time'] ? date('Y-m-d H:i:s', $v['task_start_time']) : '无';
            $list[$k]['task_end_time'] = $v['task_end_time'] ? date('Y-m-d H:i:s', $v['task_end_time']) : '无';
            $list[$k]['is_timing'] = $v['is_timing']==1 ? '是' : '否';
            switch ($v['status']) {
                case 1: $list[$k]['status'] = '测试中'; break;
                case 2: $list[$k]['status'] = '已完成'; break;
                default: $list[$k]['status'] = '未开始'; break;
            }
        }
        
        return Restful::code(Restful::SUCCESS())->data($list)->setMsg('获取成功')->callback();
    }
}