<?php

namespace app\http\test\usecase;
use x\controller\Http;

class task_log extends Http
{
    private $html = '';
    /**
     * @Param(name="id", empty="true", tips="缺少报告ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::get();

        $info = $this->Db->name('task')->where('id', $param['id'])->find();
        $param['template_id'] = $info['template_id'];
        $this->assign('param', $param);	

        $item = $this->Db->name('item')->order('id ASC')->field('id, title')->select();
        $this->assign('item', $item);
        
        $list = $this->Db->name('test_template_tree')->alias('A')
                ->join('item B', 'A.item_id=B.id')
                ->join('api C', 'A.api_id=C.id')
                ->join('test_usecase D', 'A.usecase_id=D.id')
                ->join('item E', 'C.item_id=E.id')
                ->field('A.*, B.title as item, C.title as api, C.host_url, C.domain_id, C.return_id, D.title as usecase, E.domain_id as domain_id2, E.return_id as return_id2')
                ->where('A.template_id', $info['template_id'])
                ->select();
        foreach ($list as $k=>$v) {
            if ($v['domain_id']) {
                $res = $this->Db->name('domain')->where('id', $v['domain_id'])->field('domain')->find();
            } else {
                $res = $this->Db->name('domain')->where('id', $v['domain_id2'])->field('domain')->find();
            }
            $list[$k]['host_url'] = $res['domain'].$v['host_url'];
        }
        $this->assign('list', $list);

        $list = $this->tree($list);
        $this->treeHtml($list, '', $param['id']);
        $this->assign('html', '<ul id="org" style="display:none">'.$this->html.'</ul>');
        $this->assign('title', '集成测试报告详情');
        return $this->display('test/usecase/task_log');
    }

    private function tree($list, $name = 'list', $pid = 0) {
        $arr = [];
        foreach ($list as $v) {
            if ($v['pid'] == $pid) {
                $v[$name] = $this->tree($list, $name, $v['id']);
                $arr[] = $v;
            }
        }
        return $arr;
    }
    private function treeHtml($list, $code='', $task_id) {
        $css2 = 'style="background-color: #333;color: #fff;padding: 5px 10px;border-radius: 5px;"';
        foreach ($list as $kk=>$v) {
            if ($v['code'] != $code) continue;
            $button = '';
            $res = $this->Db->name('task_log')->where('task_id', $task_id)->where('tree_id', $v['id'])->field('id, yes')->find();
            if ($code == '') {
                if (!empty($res) && $res['yes'] == 1) {
                    $css = 'style="background-color: #008456;color: #fff;padding: 5px 10px;border-radius: 5px;"';
                } else {
                    $css = 'style="background-color: red;color: #fff;padding: 5px 10px;border-radius: 5px;"';
                }
                if ($res) $button = '<button type="button" class="add_tree" onclick="get_test_doc(\''.$res['id'].'\')"><div class="tree_left"></div>查看报告</button>';
                $this->html .= '<li><div title="接口地址：'.$v['host_url'].'" '.$css.'>【'.$v['item'].'】'.$v['api'].'-'.$v['usecase'].$button.'</div><ul>';
            } else {
                if (!empty($res) && $res['yes'] == 1) {
                    $css = 'style="background-color: #008456;color: #fff;padding: 5px 10px;border-radius: 5px;"';
                } else {
                	if ($res) {
                		$css = 'style="background-color: red;color: #fff;padding: 5px 10px;border-radius: 5px;"';
                	} else {
                    	$css = 'style="background-color: #999;color: #fff;padding: 5px 10px;border-radius: 5px;"';
                	}
                }
                if ($res) $button = '<button type="button" class="add_tree" onclick="get_test_doc(\''.$res['id'].'\')"><div class="tree_left"></div>查看报告</button>';
                $this->html .= '<li><div title="接口地址：'.$v['host_url'].'" '.$css.'>【'.$v['item'].'】'.$v['api'].'-'.$v['usecase'].$button.'</div><ul>';
            }

            $lss = $this->Db->name('test_usecase_code')->where('usecase_id', $v['usecase_id'])->select();
            foreach ($lss as $val) {
                if ($val['status'] == 1) {
                    $hide = '';
                    if (!empty($v['list'])) {
                        foreach ($v['list'] as $vv) {
                            if ($vv['code'] == $val['code']) {
                                $code = $vv['code'];
                                break;
                            }
                        }
                    }
                } else {
                    $hide = 'no_click';
                    $code = '';
                }
                $this->html .= '<li><div '.$css2.' class="'.$hide.'">状态码：'.$val['code'].'</div>';
                    $this->html .= '<ul>';
                    if (!empty($v['list'])) {
                        $this->treeHtml($v['list'], $code, $task_id);
                    }
                    $this->html .= '</ul>';
                $this->html .= '</il>';
            }
            $this->html .= '</ul></li>';
        }
    }
}