<?php

namespace app\http\test\usecase;
use x\controller\Http;

class template_tree extends Http
{
    private $html = '';
    /**
     * @Param(name="template_id", empty="true", tips="缺少模板ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::get();
        $this->assign('param', $param);	

        $template = $this->Db->name('test_template')->where('id', $param['template_id'])->find();

        $item = $this->Db->name('item')->order('id ASC')->field('id, title')->select();
        $this->assign('item', $item);
        
        $list = $this->Db->name('test_template_tree')->alias('A')
                ->join('item B', 'A.item_id=B.id')
                ->join('api C', 'A.api_id=C.id')
                ->join('test_usecase D', 'A.usecase_id=D.id')
                ->field('A.*, B.title as item, C.title as api, D.title as usecase')
                ->where('A.template_id', $param['template_id'])
                ->select();
        $this->assign('list', $list);

        $list = $this->tree($list);
        $this->treeHtml($list);
        $this->assign('html', '<ul id="org" style="display:none">'.$this->html.'</ul>');
        $this->assign('title', $template['title'].'-集成树');
        return $this->display('test/usecase/template_tree');
    }

    private function tree($list, $name = 'list', $pid = 0) {
        $arr = [];
        foreach ($list as $v) {
            if ($v['pid'] == $pid) {
                $v[$name] = $this->tree($list, $name, $v['id']);
                $arr[] = $v;
            }
        }
        return $arr;
    }
    private function treeHtml($list, $code='') {
        foreach ($list as $kk=>$v) {
            if ($v['code'] != $code) continue;
            if ($code == '') {
                $button = '<button type="button" class="add_tree" onclick="delete_tree(\''.$v['id'].'\')"><div class="tree_left"></div>删除</button>';
                $this->html .= '<li><div>'.$v['item'].'-'.$v['api'].'-'.$v['usecase'].$button.'</div><ul>';
            } else {
                $button = '<button type="button" class="add_tree" onclick="param_tree(\''.$v['id'].'\')"><div class="tree_left"></div>查看请求参数</button>';
                $this->html .= '<li><div>'.$v['item'].'-'.$v['api'].'-'.$v['usecase'].$button.'</div><ul>';
            }

            $lss = $this->Db->name('test_usecase_code')->where('usecase_id', $v['usecase_id'])->select();
            foreach ($lss as $val) {
                if ($val['status'] == 1) {
                    $button = '<button type="button" class="add_tree" onclick="add_tree(\''.$v['id'].'\', \''.$val['code'].'\')"><div class="tree_left"></div>继续添加测试</button>';
                    $hide = '';
                    if (!empty($v['list'])) {
                        foreach ($v['list'] as $vv) {
                            if ($vv['code'] == $val['code']) {
                                $button = '<button type="button" class="add_tree add_tree2" onclick="delete_tree(\''.$vv['id'].'\')"><div class="tree_left"></div>删除</button>';
                                $button .= '<button type="button" class="add_tree add_tree3" onclick="update_tree(\''.$vv['id'].'\', \''.$vv['sleep_time'].'\')"><div class="tree_left"></div>编辑</button>';
                                $code = $vv['code'];
                                break;
                            }
                        }
                    }
                } else {
                    $button = '';
                    $hide = 'no_click';
                    $code = '';
                }
                $this->html .= '<li><div class="'.$hide.'">状态码：'.$val['code'].$button.'</div>';
                if ($button) {
                    $this->html .= '<ul>';
                    if (!empty($v['list'])) {
                        $this->treeHtml($v['list'], $code);
                    }
                    $this->html .= '</ul>';
                }
                $this->html .= '</il>';
            }
            $this->html .= '</ul></li>';
        }
    }
}