<?php

namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class template_tree_param extends Http
{
	public $html = '';
	
    /**
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::get();
        $info = $this->Db->name('test_template_tree')->where('id', $param['id'])->find();
        $this->assign('info', $info);	

        $body_list = $this->Db->name('test_template_tree_param')->where('tree_id', $info['id'])->order('id ASC')->select();
        $this->assign('body_list', $body_list);

        $top = $this->Db->name('test_template_tree')->where('id', $info['pid'])->find();
        $api_return = [];
        $list = $this->Db->name('api_return')->where('api_id', $top['api_id'])->where('pid', '0')->order('id ASC')->select();
        foreach ($list as $k=>$v) {
            $api_return[$k] = $v;
            $lt = $this->Db->name('api_return')->where('pid', $v['id'])->order('id ASC')->select();
            $api_return[$k]['list'] = $lt ?? [];
        }
        $this->assign('api_return', $api_return);

        $body = $this->Db->name('api_body')->where('api_id', $info['api_id'])->order('id ASC')->select();
        $body = $this->recursion($info['usecase_id'], $body);
        $this->recursion2($body);
        $this->assign('body', $this->html);

        $this->assign('title', '编辑当前节点的请求参数');

        return $this->display('test/usecase/template_tree_param');
    }

    public function recursion($usecase_id, $array='', $field1='id', $field2='pid', $menu = 'list', $pid = 0, $cid=0) {
        $arr = [];
        foreach ($array as $v) {
            if ($v[$field2] == 0) $cid = 0;
            $info = $this->Db->name('test_usecase_param')->where('usecase_id', $usecase_id)->where('pid', $cid)->where('field', $v['field'])->field('id, value, at_value')->find();
            if ($info) {
                $v['value'] = $info['value'];
                $v['at_value'] = $info['at_value'];
                if ($this->Db->name('test_usecase_param')->where('usecase_id', $usecase_id)->where('pid', $info['id'])->field('id')->find()) {
                    $cid = $info['id'];
                }
            } else {
                $cid = 0;
            }
            
            if ($v[$field2] == $pid) {
                $v[$menu] = $this->recursion($usecase_id, $array, $field1, $field2, $menu, $v[$field1], $cid);
                $arr[] = $v;
            }
        }

        return $arr;
    }

    public function recursion2($array='') {
        foreach ($array as $v) {
            if (isset($v['at_value']) && $v['at_value'] !== "") {
                $pr = $v['at_value'];
            } else  if (isset($v['value']) && $v['value'] !== "") {
                $pr = $v['value'];
            } else {
                $pr = '';
            }
            $level = '';
            for ($i=$v['level']; $i > 0; $i--) { 
                $level .= '&nbsp;&nbsp;&nbsp;&nbsp;';
            }
            if ($level && !empty($v['list'])) {
                $level .= '├─';
            } else if ($level && empty($v['list'])) {
                $level .= '└─';
            }
            $this->html .= '<tr>
                        <td colspan="2"><input class="form-control" disabled value="'.$level.$v['field'].'"></td>
                        <td><input class="form-control" disabled value="'.$pr.'"></td>
                        <td><input class="form-control" disabled value="'.$v['default'].'"></td>
                        <td><input class="form-control" disabled value="'.$v['title'].'"></td>
                        <td><input class="form-control" disabled value="'.(($v['no_null']==1) ? 'Yes' : 'No').'"></td>
                    </tr>';

			if (!empty($v['list'])) {
				$this->recursion2($v['list']);
			}
        }
	}
}