<?php

namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class timing_index_ajax extends Http
{
    /**
     * @Post
     * @Param(name="template_id", empty="true", tips="缺少参数")
     * @Param(name="start_time", empty="true", tips="请选择启动日期")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $param['create_time'] = time();
        $param['template_id'] = $param['template_id'];
        $param['start_time'] = strtotime($param['start_time']);
        $param['is_timing'] = 1;

        if ($param['start_time'] <= time()) {
            return Restful::code(Restful::ERROR())->setMsg('启动时间，不能小于当前时间')->callback();
        }

        $res = $this->Db->name('task')->insert($param);
        if (!$res) return Restful::code(Restful::ERROR())->setMsg('创建失败')->callback();
        return Restful::code(Restful::SUCCESS())->setMsg('创建成功')->callback();
    }
}