<?php

namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class update extends Http
{
    /**
     * @Post
     * @Param(name="title", empty="true", tips="请输入用例名称")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        if (!empty($param['header'])) {
            $this->Db->name('test_usecase_env_request')->where('item_id', $param['item_id'])->where('domain_id', $param['id'])->delete();
            if (!empty($param['request'])) {
                foreach ($param['request'] as $k=>$v) {
                    foreach ($v as $key=>$val) {
                        $this->Db->name('test_usecase_env_request')->insert([
                            'item_id' => $param['item_id'],
                            'domain_id' => $param['id'],
                            'field' => $key,
                            'value' => $val['value'],
                            'at_value' => $val['at_value'],
                        ]);
                    }
                }
            }
            return Restful::code(Restful::SUCCESS())->setMsg('保存成功')->callback();
        } else if (!empty($param['usecase_id'])) {
            $this->Db->name('test_usecase_code')->where('usecase_id', $param['usecase_id'])->delete();
            $this->Db->name('test_usecase_param')->where('usecase_id', $param['usecase_id'])->delete();
            $this->Db->name('test_usecase_request')->where('usecase_id', $param['usecase_id'])->delete();
            $res = $this->Db->name('test_usecase')->where('id', $param['usecase_id'])->update([
                'title' => $param['title'],
                'http_code' => $param['http_code'],
                'des' => $param['des'],
                'update_time' => time(),
            ]);
            if ($res === false) {
                return Restful::code(Restful::ERROR())->setMsg('用例修改失败')->callback();
            }
        } else {
            if (empty($param['api_id'])) {
                return Restful::code(Restful::ERROR())->setMsg('请先选择需要创建用例的接口')->callback();
            }
            $item_id = $this->Db->name('api')->where('id', $param['api_id'])->value('item_id');
            $usecase_id = $this->Db->name('test_usecase')->insertGetId([
                'item_id' => $item_id,
                'api_id' => $param['api_id'],
                'group_id' => $param['group_id'],
                'title' => $param['title'],
                'http_code' => $param['http_code'],
                'des' => $param['des'],
                'create_time' => time(),
            ]);
            if (!$usecase_id) {
                return Restful::code(Restful::ERROR())->setMsg('用例创建失败')->callback();
            }
            $param['usecase_id'] = $usecase_id;
        }

        $domain_id = $param['domain_id'] ?? '';
        if (!$domain_id) {
            $item_id = $this->Db->name('test_usecase')->where('id', $param['usecase_id'])->value('item_id');
            $domain_id = $this->Db->name('item')->where('id', $item_id)->value('domain_id');
        }
        $this->Db->name('test_usecase')->where('id', $param['usecase_id'])->update([
            'domain_id3' => $domain_id
        ]);

        $pid = $param['usecase_id'];

        if (!empty($param['request'])) {
            foreach ($param['request'] as $k=>$v) {
                foreach ($v as $key=>$val) {
                    $this->Db->name('test_usecase_request')->insert([
                        'usecase_id' => $pid,
                        'field' => $key,
                        'value' => $val['value'],
                        'at_value' => $val['at_value'],
                    ]);
                }
            }
        }
        if (!empty($param['code'])) {
            foreach ($param['code'] as $k=>$v) {
                $data = [
                    'usecase_id' => $pid,
                    'code' => $k,
                    'status' => $v['status'],
                    'yes' => $v['yes'],
                ];
                $this->Db->name('test_usecase_code')->insert($data);
            }
        }
        if (!empty($param['param'])) {
            $this->body_insert($pid, $param['param']);
        }

        return Restful::code(Restful::SUCCESS())->setMsg('用例设置成功')->callback();
    }
    
    public function body_insert($usecase_id, $list, $pid=0) {
        foreach ($list as $v) {
            $data = [
                'usecase_id' => $usecase_id,
                'pid' => $pid,
                'field' => $v['field'],
                'value' => $v['value'],
                'at_value' => $v['at_value'],
            ];
            if (isset($v['at_value']) && !is_array($v['at_value'])) {
                $cid = $this->Db->name('test_usecase_param')->insertGetId($data);
                if ($cid) {
                    foreach ($v as $val) {
                        if (is_array($val)) {
                            $this->body_insert($usecase_id, [$val], $cid);
                        }
                    }
                }
            }
        }
    }
}