<?php

namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class ut_list extends Http
{
    /**
     * @Post
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $where = [];
        if (!empty($param['item_id'])) {
            $where[] = ['A.item_id', '=', $param['item_id']];
        }
        if (!empty($param['api_id'])) {
            $where[] = ['A.api_id', '=', $param['api_id']];
        }
        $total = $this->Db->name('test_ut')->alias('A')
                ->join('item B', 'A.item_id=B.id')
                ->join('api C', 'A.api_id=C.id')
                ->order('A.id DESC')
                ->where($where)
                ->count();
        $list = $this->Db->name('test_ut')->alias('A')
                ->join('item B', 'A.item_id=B.id')
                ->join('api C', 'A.api_id=C.id')
                ->order('A.id DESC')
                ->where($where)
                ->field('A.*, B.title as item_title, C.title as api_title')
                ->page($param['page'], 20)
                ->select();
        foreach ($list as $k => $v) {
            $list[$k]['start_time'] = formatTime($v['start_time']);
            if (!$v['end_time']) {
                $list[$k]['end_time'] = '运行中';
            } else {
                $list[$k]['end_time'] = formatTime($v['end_time']);
                if ($v['success_num'] == $v['num']) {
                    $list[$k]['lv'] = 100;
                } else if ($v['error_num'] == $v['num']) {
                    $list[$k]['lv'] = 0;
                } else {
                    $s = 100 / $v['num'];
                    $list[$k]['lv'] = round(($s*$v['success_num']), 2);
                }
            }
        }
        if ($total == 0) {
            $page = 1;
        } else {
            $page = ceil($total/20);
        }
        
        $status = false;
        if ($param['page'] != $page) {
            $status = true;
        }

        return Restful::code(Restful::SUCCESS())->data([
            'page' => $status,
            'data' => $list
        ])->setMsg('获取成功')->callback();
    }
}