<?php

namespace app\http\test\usecase;
use x\controller\Http;
use x\Restful;

class whole_ut extends Http
{
    /**
     * @Post
     * @Param(name="api_id", empty="true", tips="请先选择对应的接口")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $list = $this->Db->name('test_usecase')->where('api_id', $param['api_id'])->field('id')->select();
        if (!$list) {
            return Restful::code(Restful::ERROR())->setMsg('该接口下暂未创建测试用例')->callback();
        }
        $info = $this->Db->name('api')->where('id', $param['api_id'])->field('item_id')->find();
        $num = $this->Db->name('test_ut')->where('api_id', $param['api_id'])->count();
        $ut_id = $this->Db->name('test_ut')->insertGetId([
            'item_id' => $info['item_id'],
            'api_id' => $param['api_id'],
            'title' => '任务 - '.($num+1),
            'num' => count($list),
            'start_time' => time(),
        ]);
        if (!$ut_id) {
            return Restful::code(Restful::ERROR())->setMsg('测试任务创建失败')->callback();
        }

        $channel = new \Swoole\Coroutine\Channel;
        foreach ($list as $v) {
            go(function () use ($channel, $v, $ut_id){
                $obj = new \Task\Ut();
                $res = $obj->run($v['id'], $ut_id);
                $channel->push('yes');
            });
        }
        foreach ($list as $v) {
            $channel->pop();
        }
        $list = $this->Db->name('task_log')->where('ut_id', $ut_id)->select();
        $data = [
            'end_time' => time(),
            'min_ms' => 0,
            'max_ms' => 0,
            'avg_ms' => 0,
            'success_num' => 0,
            'error_num' => 0,
        ];
        foreach ($list as $k=>$v) {
            if ($k == 0) {
                $data['min_ms'] = $v['run_time'];
                $data['max_ms'] = $v['run_time'];
                $data['avg_ms'] = $v['run_time'];
            } else {
                if ($v['run_time'] < $data['min_ms']) $data['min_ms'] = $v['run_time'];
                if ($v['run_time'] > $data['max_ms']) $data['max_ms'] = $v['run_time'];
                $data['avg_ms'] += $v['run_time'];
            }

            if ($v['yes'] == 1) {
                $data['success_num']++;
            } else {
                $data['error_num']++;
            }
        }
        $data['avg_ms'] = ceil($data['avg_ms'] / count($list));
        $res = $this->Db->name('test_ut')->where('id', $ut_id)->update($data);
        if (!$res) {
            return Restful::code(Restful::ERROR())->setMsg('执行成功，但任务记录更新失败')->callback();
        }
        return Restful::code(Restful::SUCCESS())->setMsg('执行成功，测试结果：在侧栏【单元测试】菜单中查看')->callback();
    }
}