<?php

namespace app\http\word\index;
use x\controller\Http;
use x\Restful;

class insert extends Http
{
    /**
     * @Post
     * @Param(name="title", empty="true", tips="请输入文档名称")
     * @Param(name="route", empty="true", tips="请输入文档路由")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $param['create_time'] = time();

        $info = $this->Db->name('word')->where('title', $param['title'])->find();
        if ($info) {
            return Restful::code(Restful::ERROR())->setMsg('该名称已被占用')->callback();
        }
        $info = $this->Db->name('word')->where('route', $param['route'])->find();
        if ($info) {
            return Restful::code(Restful::ERROR())->setMsg('该路由已被占用')->callback();
        }

        if (!empty($param['user_id'])) {
            $param['user_id'] = json_encode($param['user_id']);
        } else {
            $param['user_id'] = json_encode([]);
        }
        $admin = \x\Session::get('admin');
        $param['admin_id'] = $admin['id'];

        $res = $this->Db->name('word')->insert($param);
        if ($res === false) {
            return Restful::code(Restful::ERROR())->setMsg('文档创建失败')->callback();
        }
        return Restful::code(Restful::SUCCESS())->setMsg('文档创建成功')->callback();
    }
}