<?php


namespace app\http\word\index;
use x\controller\Http;
use x\Restful;

class update extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="title", empty="true", tips="请输入文档名称")
     * @Param(name="route", empty="true", tips="请输入文档路由")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $param['create_time'] = time();

        $info = $this->Db->name('word')->where('title', $param['title'])->where('id', '<>', $param['id'])->find();
        if ($info) {
            return Restful::code(Restful::ERROR())->setMsg('该名称已被占用')->callback();
        }
        $info = $this->Db->name('word')->where('route', $param['route'])->where('id', '<>', $param['id'])->find();
        if ($info) {
            return Restful::code(Restful::ERROR())->setMsg('该路由已被占用')->callback();
        }

        if (!empty($param['user_id'])) {
            $param['user_id'] = json_encode($param['user_id']);
        } else {
            $param['user_id'] = json_encode([]);
        }

        $res = $this->Db->name('word')->where('id', $param['id'])->update($param);
        if ($res === false) {
            return Restful::code(Restful::ERROR())->setMsg('文档修改失败')->callback();
        }
        return Restful::code(Restful::SUCCESS())->setMsg('文档修改成功')->callback();
    }
}