<?php


namespace app\http\word\tree;
use x\controller\Http;
use x\Restful;

class insert extends Http
{
    /**
     * @Post
     * @Param(name="title", empty="true", tips="请输入章节名称")
     * @Param(name="word_id", empty="true", tips="请先选择文档")
     * @Param(name="pid", value="0")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $admin = \x\Session::get('admin');
        $data = [
            'title' => $param['title'],
            'word_id' => $param['word_id'],
            'pid' => $param['pid'],
            'status' => $param['status'],
            'content' => $param['content'],
            'top' => $param['top'],
            'type' => $param['type'],
            'editor_type' => $param['editor_type'],
            'update_time' => time(),
            'admin_id' => $admin['id'],
        ];
        $info = $this->Db->name('word_tree')->where('title', $data['title'])->where('word_id', $data['word_id'])->where('pid', $data['pid'])->find();
        if ($info) {
            return Restful::code(Restful::ERROR())->setMsg('该章节名称已被占用')->callback();
        }

        if (!empty($param['route'])) {
            $data['route'] = $param['route'];
            $info = $this->Db->name('word_tree')->where('route', $data['route'])->where('word_id', $data['word_id'])->find();
            if ($info) {
                return Restful::code(Restful::ERROR())->setMsg('该路由地址已被占用')->callback();
            }
        } else {
            $data['route'] = \x\Snowflake::create();
        }

        $id = $this->Db->name('word_tree')->insertGetId($data);
        if ($id === false) {
            return Restful::code(Restful::ERROR())->setMsg('章节创建失败')->callback();
        }
        if ($param['pid'] == 0) {
            $this->Db->name('word_tree')->where('id', $id)->update(['path' => $id]);
        } else {
            $path = $this->Db->name('word_tree')->where('id', $param['pid'])->value('path');
            $this->Db->name('word_tree')->where('id', $id)->update(['path' => $path.'/'.$id]);
        }

        return Restful::code(Restful::SUCCESS())->setMsg('章节创建成功')->callback();
    }
}