<?php


namespace app\http\word\tree;
use x\controller\Http;
use x\Restful;

class update extends Http
{
    /**
     * @Post
     * @Param(name="id", empty="true", tips="请输入ID")
     * @Param(name="title", empty="true", tips="请输入章节名称")
     * @Ioc(class="\x\Db", name="Db")
    */
    public function index() {
        $param = \x\Request::post();
        $admin = \x\Session::get('admin');
        $data = [
            'title' => $param['title'],
            'status' => $param['status'],
            'content' => $param['content'],
            'top' => $param['top'],
            'type' => $param['type'],
            'editor_type' => $param['editor_type'],
            'update_time' => time(),
            'admin_id' => $admin['id'],
        ];
        $tree =  $this->Db->name('word_tree')->where('id', $param['id'])->field('word_id, pid')->find();
        $info = $this->Db->name('word_tree')->where('title', $data['title'])->where('word_id', $tree['word_id'])->where('pid', $tree['pid'])->where('id', '<>', $param['id'])->find();
        if ($info) {
            return Restful::code(Restful::ERROR())->setMsg('该章节名称已被占用')->callback();
        }

        if (!empty($param['route'])) {
            $data['route'] = $param['route'];
            $info = $this->Db->name('word_tree')->where('route', $data['route'])->where('word_id', $tree['word_id'])->where('id', '<>', $param['id'])->find();
            if ($info) {
                return Restful::code(Restful::ERROR())->setMsg('该路由地址已被占用')->callback();
            }
        } else {
            $data['route'] = \x\Snowflake::create();
        }

        $res = $this->Db->name('word_tree')->where('id', $param['id'])->update($data);
        if ($res === false) {
            return Restful::code(Restful::ERROR())->setMsg('章节修改失败')->callback();
        }
        return Restful::code(Restful::SUCCESS())->setMsg('章节修改成功')->callback();
    }
}