<?php

namespace box;
use \x\controller\Http;
use x\Restful;

class http_error  extends Http{
    private $html = '<html><head><meta charset="UTF-8"><title>HTTP 404</title><meta name="robots"content="noindex,nofollow"/><meta name="viewport"content="width=device-width, initial-scale=1, user-scalable=no"></head><body style="text-align: center;"><h1 style="padding-top: 20%;font-size: 50px;color: #3674ff;margin: 0;">SW-X</h1><h2 style="font-size: 13.5px;color: #6f6f6f;margin: 35px 0;font-weight: 500;">抱歉，您要查看的数据不存在或已被删除。</h3></body></html>';
   
    public function __construct() {
        $url = \x\Request::url(true);
        $info = parse_url($url);
        $url = str_replace(['/apiword/', '.html'], '', $info['path']);
        $url = explode('/', $url);
        if (!$url) {
            return $this->send404();
        }

        $Db = new \x\Db;
        $word_route = $url[0];
        $word = $Db->name('word')->where('route', $word_route)->where('status', 1)->find();
        if (!$word) {
            return $this->send404();
        	return $this->fetch($this->html, '404');
        }
        $this->assign('word', $word);

        $user = \x\Session::get('word_user');
        if ($word['is_login'] == 1 && empty($user)) {
            $this->assign('havior', \x\verify\Havior::create('shop_havior'));
            return $this->display('apiword/login');
        }
        $user_id = json_decode($word['user_id'], true);
        $user_id = $user_id ? $user_id : [];
        if ($word['is_login'] == 1) {
            if (in_array($user['id'], $user_id) == false) {
                return $this->fetch('<h2 style="font-size: 13.5px;color: #6f6f6f;height: 90%;line-height: 60;text-align: center;font-weight: 500;">抱歉，您暂无权限查看该文档。</h2>', '500');
            }
        }
        
        if (isset($url[1]) && $url[1] == 'index') {
        	$url[1] = '';
        }
        if (!empty($url[1])) {
            $info = $Db->name('word_tree')->where('word_id', $word['id'])->where('route', $url[1])->where('status', 1)->find();
        } else {
            $info = $Db->name('word_tree')->where('word_id', $word['id'])->where('status', 1)->where('top', 1)->order('id ASC')->find();
            if (!$info) {
                $info = $Db->name('word_tree')->where('word_id', $word['id'])->where('status', 1)->where('pid', '<>', 0)->order('top desc, id ASC')->find();
                if (!$info) {
                    $info = $Db->name('word_tree')->where('word_id', $word['id'])->where('status', 1)->order('top desc, id ASC')->find();
                }
            }
        }
        if (!$info) {
        	return $this->fetch('<h2 style="font-size: 13.5px;color: #6f6f6f;height: 90%;line-height: 60;text-align: center;font-weight: 500;">抱歉，查询不到该文档。</h2>', '500');
        }

        if (\x\Request::is_ajax()) {
            return Restful::code(Restful::SUCCESS())->setMsg('读取成功')->data($info)->callback();
        }

        $this->assign('admin_nick', $Db->name('auth_admin')->where('id', $info['admin_id'])->value('fullname'));
        $this->assign('info', $info);
        $this->assign('word_route', $word_route);
        
        $word_list = $Db->name('word')->where('status', 1)->order('id ASC')->select();
        $list = [];
        foreach ($word_list as $v) {
            if ($v['is_login'] == 0) {
                $list[] = $v;
            } else {
                $user_id = json_decode($v['user_id'], true);
                if ($word['is_login'] == 1 && in_array($user['id'], $user_id)) {
                    $list[] = $v;
                }
            }
        }
        $this->assign('word_list',  $list);
        
        $list = $Db->name('word_tree')->where('word_id', $word['id'])
        		->where('status', 1)
        		->order('id ASC')
        		->field('id, pid, title, route, type')
        		->select();
        $this->assign('list', $this->menu_make($list));

        return $this->display('apiword/index');
    }

    private function send404() {
        $url = str_replace(\x\Request::domain(), '', \x\Request::url(true));
        $Db = new \x\Db();
        $code = $Db->name('api')->where('is_imitate_api', 1)->where('imitate_route', $url)->value('imitate_code');
        if ($code) {
            $ret = $this->run_route($url, $code);
            if (is_array($ret) || is_null($ret) || is_object($ret)) {
                $ret = dd($ret);
            }
            return $this->fetch($ret, 404);
        }

        return $this->fetch($this->html, 404);
    }

    private function run_route($name, $content) {
        if (stripos($content, '<?php') === 0) {
            $needle = "<?php";
            $content = substr_replace($content, "", 0, strlen($needle));
        }
        $fun = 'swoolex_imitate_route_'.md5($name);
        if (!function_exists($fun)) {
            $code = 'function '.$fun.'() {'.$content.'}';
            eval($code);
        }
        return $fun();
    }

    protected function menu_make($cate='', $name = 'list', $pid = 0) {
        $arr = [];
        foreach ($cate as $v) {
            if ($v['pid'] == $pid) {
                $v[$name] = $this->menu_make($cate, $name, $v['id']);
                $arr[] = $v;
            } 
        }
        return $arr;
    }

}