<?php
/**
 * +----------------------------------------------------------------------
 * 登录权限中间件
 * +----------------------------------------------------------------------
 * 官网：https://www.sw-x.cn
 * +----------------------------------------------------------------------
 * 作者：小黄牛 <1731223728@qq.com>
 * +----------------------------------------------------------------------
 * 开源协议：http://www.apache.org/licenses/LICENSE-2.0
 * +----------------------------------------------------------------------
*/
namespace box\middleware;
use x\Middleware;
use x\Restful;
use x\Session;

class Auth extends Middleware{

	/**
	 * 前置操作
	 * @todo 无
	 * @author 小黄牛
	 * @version v2.5.0 + 2021.07.20
	 * @deprecated 暂不启用
	 * @global 无
	 * @return void
	*/
	public function handle() {
        $admin = Session::get('admin');
        if (!$admin) {
            if (\x\Request::is_ajax()) {
                Restful::code(Restful::LOGIN())->setMsg('您已掉线，请重新登录账号')->callback();
            } else {
                $controller = new \x\controller\Http();
                $controller->redirect('/login');
            }
            return false;
        }

        $list = getAdminMenu($admin['role_id']);

        $route = \x\Config::get('route');
		$url = str_replace($route['suffix'], '', \x\Request::url());
		
		if (!in_array(getRoute(), $list)) {
            Restful::code(Restful::LOGIN())->setMsg('您暂无该权限操作')->callback();
            return false;
        }

		return true;
	}
}