<?php

function formatTime($time){
    $t = time()-$time;
    $f = [
        '31536000'=>'年',
        '2592000'=>'个月',
        '604800'=>'星期',
        '86400'=>'天',
        '3600'=>'小时',
        '60'=>'分钟',
        '1'=>'秒'
    ];
    foreach ($f as $k=>$v)    {
        if (0 !=$c=floor($t/(int)$k)) {
            return $c.$v.'前';
        }
    }
    return '0 秒前';
}

function request_list($key=null) {
    $list = [
        1 => "GET",
        2 => "POST",
        3 => "RPC",
    ];
    if ($key) {
        if (isset($list[$key])) return $list[$key];
        return false;
    }
    return $list;
}

function param_list($key=null) {
    $list = [
        1 => "Form-data",
        2 => "Json",
        3 => "Xml",
        4 => "RPC",
    ];
    if ($key) {
        if (isset($list[$key])) return $list[$key];
        return false;
    }
    return $list;
}

function type_list($key=null) {
    $list = [
        1 => "string",
        2 => "int",
        3 => "float",
        4 => "bool",
        5 => "array",
        6 => "json",
        7 => "null",
        8 => "object",
        9 => "date",
        10 => 'xml',
        11 => 'file',
    ];
    if ($key) {
        if (isset($list[$key])) return $list[$key];
        return false;
    }
    return $list;
}

function code_list() {
    $list = [
        200,
        100,
        101,
        102,
        201,
        202,
        203,
        204,
        205,
        206,
        207,
        300,
        301,
        302,
        303,
        304,
        305,
        306,
        307,
        400,
        401,
        402,
        403,
        404,
        405,
        406,
        407,
        408,
        409,
        410,
        411,
        412,
        413,
        414,
        415,
        416,
        417,
        421,
        422,
        422,
        424,
        425,
        426,
        449,
        500,
        501,
        502,
        503,
        504,
        505,
        506,
        507,
        509,
        510,
    ];
    return $list;
}

function tag($str) {
	$arr = explode('<pre><code>', $str);
	unset($arr[0]);
	foreach ($arr as $v) {
		$array = explode('</code></pre>', $v);
		if (count($array) == 2) {
			$val = str_replace('<', '&lt;', $array[0]);
			$str = str_replace($array[0], $val, $str);
		}
	}
	return $str;
}
function getAdminMenu($role_id) {
    $Db = new \x\Db();
    if ($role_id == 0){
        $menu = $Db->name('auth_menu')->where('status', 1)->field('route')->select();
    } else {
        $id = $Db->name('auth_role')->where('id', $role_id)->value('menu_list');
        $menu = $Db->name('auth_menu')->where('status', 1)->whereIn('id', '('.$id.')')->field('route')->select();
    }
    $list = [];
    foreach ($menu as $v) {
        $list[] = $v['route'];
    }
    $Db->return();
    return $list;
}
function getRoute() {
    $route = \x\Config::get('route');
	return str_replace($route['suffix'], '', \x\Request::url());
}
function getAuthData($role_id) {
    $list = getAdminMenu($role_id);
    $data = [
        'api' => false,
        'test' => false,
        'word' => false,
        'auth' => false,
        'code' => false,
        'robot' => false,
    ];
    if (in_array('/', $list)) $data['api'] = true;
    if (in_array('/test', $list)) $data['test'] = true;
    if (in_array('/word', $list)) $data['word'] = true;
    if (in_array('/auth', $list)) $data['auth'] = true;
    if (in_array('/code', $list)) $data['code'] = true;
    if (in_array('/robot', $list)) $data['robot'] = true;

    return $data;
}