<?php
/**
 * +----------------------------------------------------------------------
 * 限流器配置
 * +----------------------------------------------------------------------
 * 官网：https://www.sw-x.cn
 * +----------------------------------------------------------------------
 * 作者：小黄牛 <1731223728@qq.com>
 * +----------------------------------------------------------------------
 * 开源协议：http://www.apache.org/licenses/LICENSE-2.0
 * +----------------------------------------------------------------------
*/

return [
    // +-----------------------------
    // | 基于-路由限流
    // +-----------------------------
    'route' => [
        // 限流开关 true.开  false.关
        'limit_switch' => false,
        // 是否全部路由开启 true.开  false.关
        'global_switch' => false,
        // 统计器重置间隔时间【理解为每次统计的间隔时间】
        'reset_time' => 1,
        // 限流峰值
        'peak_num' => 60,
        // 启用日期，支持【年-月-日】、【时:分：秒】格式
        'start_date' => false,
        // 关闭日期，支持【年-月-日】、【时:分：秒】格式
        'end_date' => false,
        // 限流器触发回调地址
        'callback' => '\\box\\lifecycle\\limit_route_check',
    ],

    // +-----------------------------
    // | 基于-IP限流
    // +-----------------------------
    'ip' => [
        // 限流开关 true.开  false.关
        'limit_switch' => false,
        // 统计器重置间隔时间【理解为每次统计的间隔时间】
        'reset_time' => (86400*7),
        // 限流峰值
        'peak_num' => 1000,
        // 启用日期，支持【年-月-日】、【时:分：秒】格式
        'start_date' => false,
        // 关闭日期，支持【年-月-日】、【时:分：秒】格式
        'end_date' => false,
        // 限流器触发回调地址
        'callback' => '\\box\\lifecycle\\limit_ip_check',
    ],
];