<?php
namespace Robot;

class RobotTool {
   
    public static function array_sort($data, $num=5){ 
        $last_names = array_column($data,'num');
        array_multisort($last_names,SORT_DESC,$data);

        $list = [];
        $i=1;

        foreach ($data as $value) {
            if ($i>$num) break;
            $list[] = $value;
            $i++;
        }
        $status = false;
        if ($list) {
            if ($list[0]['num'] > 0) $status = true;
        }
        if ($status) {
            foreach ($list as $key => $value) {
                if ($value['num'] == 0) unset($list[$key]); 
            }
        }
        return $list; 
    }

    public static function PosOffset($arr1, $i, $arr2){
        $len2 = count($arr2);
        $arr2_reverse = array_reverse($arr2);
        for($j = 0; $j < $len2; $j++){
            $rev_num = abs($i-$j)-1;
            $rev_data = isset($arr2_reverse[$rev_num]) ? $arr2_reverse[$rev_num] : '';
            $notrev_data = isset($arr2[$i-$j]) ? $arr2[$i-$j] : '';
            if($i+$j >= 0 && $arr1[$i] == ($i-$j >=0 ? $notrev_data : $rev_data)){
                return $j;
            }
            if($i+$j < $len2 && $arr1[$i] == $arr2[$i+$j]){
                return $j;
            }
        }
        return $len2;
    }

    public static function CC($arr1, $i, $arr2){
        $len2 = count($arr2);
        $len2_float = sprintf("%.2f", $len2);
        $temp = self::PosOffset($arr1, $i, $arr2);
        $data = ($len2 - $temp) / $len2_float;
        return $data;
    }

    public static function SC($arr1, $arr2){
        $sc = 0.0;
        $len1 = count($arr1);
        for($i = 0; $i < $len1; $i++){
            $sc += self::CC($arr1, $i, $arr2);
        }
        $sc /= $len1;
        return $sc;
    }

    public static function S($arr1, $arr2){
        $temp1 = self::SC($arr1, $arr2);
        $temp2 = self::SC($arr2, $arr1);
        return ($temp1 + $temp2)/2;
    }

    public static function CharToArr($str){
        return preg_split('/(?<!^)(?!$)/u', $str );
    }

}