<?php

namespace Robot\phpcutting;

class Phpcutting {

    public function run($string) {
        $en = $this->english($string);
        foreach ($en as $value) {
            $string = str_replace($value, '', $string);
        }

        $string = str_replace(["\r", "\n", ' ', ',', ':', '_', '/', '，', '.', '。', '!', '！', '：'], '', $string);

        $zh = $this->mbStrSplit($string);
        
        return ['en'=>$en, 'zh'=>$zh];
    }

    private function english($string) {
        $parrten = "/[a-zA-Z]+/";
        preg_match_all($parrten,$string,$arr);
        return $arr[0];
    }

    private function mbStrSplit($string, $len=2) {
        $array = [];
        $start = 0;
        $strlen = mb_strlen($string);
        while ($strlen) {
          $array[] = mb_substr($string,$start,$len,"utf8");
          $string = mb_substr($string, $len, $strlen,"utf8");
          $strlen = mb_strlen($string);
        }
        return $array;
    }

    public function record($string) {
        $file = dirname(__FILE__).'/txt/cutting.txt';
        $txt = file_get_contents($file);
        if ($txt) {
            $arr = explode('|', $txt);
            foreach ($arr as $v) {
                if ($string == $v) {
                    return false;
                }
            }
            file_put_contents($file, '|'.$string, FILE_APPEND);
        } else {
            file_put_contents($file, $string);
        }

        return true;
    }
}