<?php
namespace Task;
use Task\Usecase;
use Task\Curl;

class Ab {

	public function run($usecase_id, $ab_id) {
        $Usecase = new Usecase();
        $usecase_info = $Usecase->run($usecase_id);
        $Db = new \x\Db();
        $Db->name('test_ab')->where('id', $ab_id)->update([
            'start_time' => time(),
            'end_time' => '',
            'actual_for_num' => '',
            'min_ms' => '',
            'max_ms' => '',
            'avg_ms' => '',
        ]);
        $Db->name('test_ab_log')->where('ab_id', $ab_id)->delete();
        $task = $Db->name('test_ab')->where('id', $ab_id)->find();
        $Db->return();
        
        $thread_num = $task['thread_num'];
        $ramp_up = !empty($task['ramp_up']) ? $task['ramp_up'] : 0; 
        $for_num = !empty($task['for_num']) ? $task['for_num'] : 0;
        $duration = !empty($task['duration']) ? $task['duration'] : 0;
        if ($ramp_up) {
            $thread_num = floor($thread_num / $ramp_up);
        }
        $end_time = time()+$duration;
        $actual_for_num = 0;
        $min_ms = null;
        $max_ms = null;

        do {
            $channel = new \Swoole\Coroutine\Channel;
            for ($i=0; $i<$thread_num; $i++) {
                go(function () use ($channel, $usecase_info, $ab_id){
                    $Curl = new \Task\Curl();
                    $res = $Curl->run($usecase_info, [], 0, 0);
                    $Db = new \x\Db();
                    $Db->name('test_ab_log')->insert([
                        'ab_id' => $ab_id,
                        'ms' => $res['run_time'],
                        'yes' => $res['yes'],
                        'status_code' => $res['status_code'],
                        'time' => time(),
                    ]);
                    $Db->return();
                    $channel->push($res['run_time']);
                });
            }
            for ($i=0; $i<$thread_num; $i++) {
                $ms = $channel->pop();
                if ($min_ms == null || $ms < $min_ms) $min_ms = $ms;
                if ($max_ms == null || $ms > $max_ms) $max_ms = $ms;
            }
            $actual_for_num++;
            
            if ($for_num != 0) {
                if ($actual_for_num >= $for_num) {
                    break;
                } else {
                    $end_time = time()+10;
                }
            } else if ($ramp_up != 0){
                if ($actual_for_num >= $ramp_up) {
                    break;
                } else {
                    $end_time = time()+10;
                }
            }
        } while (time() < $end_time);

        $Db = new \x\Db();
        $avg_ms = $Db->name('test_ab_log')->where('ab_id', $ab_id)->avg('ms');
        $Db->name('test_ab')->where('id', $ab_id)->update([
            'end_time' => time(),
            'actual_for_num' => $actual_for_num,
            'min_ms' => $min_ms,
            'max_ms' => $max_ms,
            'avg_ms' => $avg_ms,
        ]);
        $Db->return();
	}
	
}  
