<?php
namespace Task;
use Task\Tool;

class Curl {

	private $body_param = [];
	public function run($info, $tree_list=[], $task_id=0, $ut_id=0, $global_return=[], $at_status=false) {

		if (!empty($info['sleep_time'])) {
			if ($info['sleep_time'] > 0) {
				\Swoole\Coroutine\System::sleep($info['sleep_time']);
			}
		}
		$api_url = $info['host_url']; 
		$param_type = $info['param_type'];
		if (!empty($info['body_param'])) {
			foreach ($info['body_param'] as $v) {
				if (!empty($v['list'])) {
					$this->body_param[$v['field']] = $this->recursion($v['list'], $info, $global_return, $at_status);
					if ($v['param_type'] == 6) {
						$this->body_param[$v['field']] = json_encode($this->body_param[$v['field']], JSON_UNESCAPED_UNICODE);
					}
				} else {
					if (!is_null($v['at_value']) && $at_status==true) {
						$this->body_param[$v['field']] = Tool::evalRun($v['at_value'], $info, $global_return, $this->body_param, []);
					} else if (isset($v['value'])) {
						$this->body_param[$v['field']] = Tool::evalRun($v['value'], $info, $global_return, $this->body_param, []);
					}

					if ($v['param_type'] == 2) {
						$this->body_param[$v['field']] = (int)$this->body_param[$v['field']];
					} else if ($v['param_type'] == 3) {
						$this->body_param[$v['field']] = (float)$this->body_param[$v['field']];
					}
				}
			}
		}
		$body_param = $this->body_param;
		
		$request_param = [];
		if (!empty($info['request_param'])) {
			foreach ($info['request_param'] as $v) {
				if (!empty($v['at_value']) && $at_status==true) {
					$request_param[$v['field']] = Tool::evalRun($v['at_value'], $info, $global_return, $body_param, []);
				} else if (isset($v['value'])) {
					$request_param[$v['field']] = Tool::evalRun($v['value'], $info, $global_return, $body_param, []);
				}
			}
		}
        
		$DbData = [
			'task_id' => $task_id,
			'template_id' => $info['template_id']??false,
			'tree_id' => $info['id'],
			'item_id' => $info['item_id'],
			'api_id' => $info['api_id'],
			'usecase_id' => $info['usecase_id'],
			'api_title' => $info['api_title'],
			'api_url' => $api_url,
			'request_type' => $info['request_type'],
			'param_type' => $param_type,
			'create_time' => time(),
		];

		if ($param_type == 1) { 
			$DbData['request_json'] = json_encode($request_param);
			$DbData['body_json'] = json_encode($body_param);
		} else if ($param_type == 2) { 
			$body_param = json_encode($body_param);
			$request_param['Content-Type'] = 'application/json; charset=utf-8';
			$request_param['Content-Length'] = strlen($body_param);

			$DbData['request_json'] = json_encode($request_param);
			$DbData['body_json'] = $body_param;
		} else if ($param_type == 3) { 
			$request_param['Content-Type'] = 'text/xml; charset=utf-8';
			
			$DbData['request_json'] = json_encode($request_param);
			$DbData['body_json'] = json_encode($body_param);

			$body_param = Tool::array2Xml($body_param);
		}

		$start_time = microtime(true);
		$httpClient = new \x\Client();
        $http = $httpClient->http()
                ->domain($api_url)
                ->set([
                    'timeout' => 60 
                ])
                ->setHeaders($request_param)
				->body($body_param?:array());
        if (!empty($info['cookie'])) {
			$http->setCookies($info['cookie']);
		}
		if ($info['request_type'] == 2) {
			$http->setMethod('POST');   
			$body = $http->post();
		} else {
			$body = $http->get();
		}
		$end_time = microtime(true); 

		$cookie = $http->cookies();
		$statusCode = $http->statusCode();
		$err_code = $http->errCode();
		$responseHead = $http->getHeaders();
        if (is_array($responseHead)) $responseHead = json_encode($responseHead, JSON_UNESCAPED_UNICODE);
        $code_list = [];
        foreach ($info['code_param'] as $v) {
            $code_list[] = $v['code'];
        } 
        $log_body = $body;
        if (is_array($log_body)) $log_body = json_encode($log_body, JSON_UNESCAPED_UNICODE);
        $DbData['yes'] = 1;
		if ($info['return_type'] == 2) {
            $body = json_decode($body, true);
            if (!empty($code_list) && in_array($body[$info['return_code_field']], $code_list) == false) {
				$DbData['yes'] = 0;
				$DbData['yes_des'] = '接口响应的'.$info['return_code_field'].'值不符合预期';
            }
		} if ($info['return_type'] == 3) {
            if (!empty($code_list) &&  in_array($body[$info['return_code_field']], $code_list) == false) {
                $DbData['yes'] = 0;
				$DbData['yes_des'] = '接口响应的'.$info['return_code_field'].'值不符合预期';
            }
            $body = Tool::xml2Array($body);
		}

		if ($at_status == true && !empty($body[$info['return_data_field']])) {
			$global_return = array_merge($global_return, $body[$info['return_data_field']]);
		}

		$DbData['return_head'] = $responseHead;
		$DbData['return_json'] = $log_body;
		$DbData['status_code'] = $statusCode;
		$DbData['err_code'] = $err_code;
		$DbData['run_time'] = round(($end_time - $start_time) * 1000, 0);

        if ($statusCode != $info['http_code']) {
			$DbData['yes'] = 0;
			$DbData['yes_des'] = 'HTTP响应的状态码不符合预期';
		}
		if ($ut_id) {
			$DbData['template_id'] = 0;
			$DbData['ut_id'] = $ut_id;
			$Db = new \x\Db();
			$id = $Db->name('task_log')->insertGetId($DbData);
			$Db->return();
			$DbData['id'] = $id;
		}
		if (!$task_id) {
            return $DbData;
        }

        if ($err_code || $statusCode != 200) {
            $Db = new \x\Db();
            $Db->name('task')->where('id', $task_id)->update([
                'status' => 2,
                'task_end_time' => time(),
            ]);
            $Db->name('task_log')->insert($DbData);
            $Db->return();
        } else {
            $Db = new \x\Db();
            $code = $body[$info['return_code_field']] ?? '';
            $return_data = $body[$info['return_data_field']] ?? [];

            $Db->name('task_log')->insert($DbData);

            $tree_info = [];
            foreach ($tree_list as $val) {
                $pid_code = str_replace(' ', '', $val['code']);
                if ($val['pid'] == $info['id'] && $pid_code == $code) {
                    $tree_info = $val;
                    break;
                }
            }

            if ($tree_info) {
                $Db->name('task')->where('id', $task_id)->setInc('success_num', 1);
                $Db->return();
                $obj = new \Task\LoopSend();
                $obj->run($task_id, $tree_info, $tree_list, $return_data, $global_return, $cookie);
            } else {
                $Db->name('task')->where('id', $task_id)->update([
                    'status' => 2,
                    'task_end_time' => time(),
                ]);
                $Db->return();
            }
		}
		
		if ($DbData['template_id'] === false) {
			$DbData['template_id'] = 0;
			$Db = new \x\Db();
			$id = $Db->name('task_log')->insertGetId($DbData);
			$Db->return();
			$DbData['id'] = $id;
			return $DbData;
		}
	}

	public function recursion($array='', $info, $global_return, $at_status) {
        $arr = [];
        foreach ($array as $v) {
			if (!empty($v['list'])) {
				$arr[$v['field']] = $this->recursion($v['list'], $info, $global_return, $at_status);
				if ($v['param_type'] == 6) {
					$arr[$v['field']] = json_encode($arr[$v['field']], JSON_UNESCAPED_UNICODE);
				}
			} else {
				if (!empty($v['at_value']) && $at_status==true) {
					$arr[$v['field']] = Tool::evalRun($v['at_value'], $info, $global_return, $this->body_param, []);
				} else if (isset($v['value'])) {
					$arr[$v['field']] = Tool::evalRun($v['value'], $info, $global_return, $this->body_param, []);
				}

				if ($v['param_type'] == 2) {
					$arr[$v['field']] = (int)$arr[$v['field']];
				} else if ($v['param_type'] == 3) {
					$arr[$v['field']] = (float)$arr[$v['field']];
				}
			}
        }
        return $arr;
	}
}  
