<?php
namespace Task;
use Task\Usecase;
use Task\Curl;

class JsonToTree {
    private $data = [];

    public function analysis($arr) {
        $this->data = [];
        $arr = $this->recursion($arr);

        $list = [];
        foreach ($arr as $k=>$v){
            $tree = $v['list'];
            unset($v['list']);
            $this->data[$v['field']] = $v;
            $list[] = $v['field'];
            $treeArray = $this->tree($v['field'], $tree);
            $list = array_merge($list, $treeArray);
        }
        return $this->data;
    }
    private function recursion($array='', $field1='id', $field2='pid', $menu = 'list', $pid = 0) {
        $arr = [];
        foreach ($array as $v) {
            if ($v[$field2] == $pid) {
                $v[$menu] = $this->recursion($array, $field1, $field2, $menu, $v[$field1]);
                $arr[] = $v;
            }
        }
        return $arr;
    }
    private function tree($title, $arr, $list = []) {
        foreach ($arr as $v) {
            $tree = $v['list'];
            unset($v['list']);
            $list[] = $title.'['.$v['field'].']';
            $this->data[$title.'['.$v['field'].']'] = $v;
            $list = $this->tree($title.'['.$v['field'].']', $tree, $list);
        }
        return $list;
    }
}