<?php
namespace Task;

class Start {
	
	public function run($info) {
		$Db = new \x\Db();
		$field = 'A.*, B.title as api_title, B.host_url, B.domain_id as domain_id, B.return_id as return_id, B.request_type, B.param_type, C.domain_id as domain_id2, C.return_id as return_id2';
		$tree_list = $Db->name('test_template_tree')->alias('A')
					 ->join('api B', 'A.api_id=B.id')
					 ->join('item C', 'A.item_id=C.id')
					 ->where('A.template_id', $info['template_id'])
					 ->field($field)
					 ->order('A.pid ASC')
					 ->select();
		foreach ($tree_list as $k=>$v) {
            if ($v['domain_id']) {
                $domain = $Db->name('domain')->where('id', $v['domain_id'])->value('domain');
            } else {
                $domain = $Db->name('domain')->where('id', $v['domain_id2'])->value('domain');
            }
			$tree_list[$k]['host_url'] = $domain.$v['host_url'];
			if ($v['return_id']) {
				$return_type = $Db->name('return')->where('id', $v['return_id'])->value('return_type');
				$return_list = $Db->name('return_field')->where('pid', $v['return_id'])->field('field, is_code, is_data')->select();
            } else {
                $return_type = $Db->name('return')->where('id', $v['return_id2'])->value('return_type');
				$return_list = $Db->name('return_field')->where('pid', $v['return_id2'])->field('field, is_code, is_data')->select();
			}
			$tree_list[$k]['return_type'] = $return_type;
			$tree_list[$k]['return_code_field'] = '';
			$tree_list[$k]['return_data_field'] = '';
			foreach ($return_list as $val) {
				if ($val['is_code'] == 1) {
					$tree_list[$k]['return_code_field'] = $val['field'];
				} else if ($val['is_data'] == 1) {
					$tree_list[$k]['return_data_field'] = $val['field'];
				}
			}
			$tree_list[$k]['body_param'] = $Db->name('api_body')->where('api_id', $v['api_id'])->field('id, pid, field')->order('id ASC')->select();
			$tree_list[$k]['request_param'] = $Db->name('api_request')->where('api_id', $v['api_id'])->field('field')->select();
            $tree_list[$k]['code_param'] = $Db->name('test_usecase_code')->where('usecase_id', $v['usecase_id'])->where('yes', 1)->field('code')->select();
            unset($tree_list[$k]['domain_id']);
            unset($tree_list[$k]['domain_id2']);
            unset($tree_list[$k]['return_id']);
            unset($tree_list[$k]['return_id2']);

            $request = $Db->name('test_usecase_request')->where('usecase_id', $v['id'])->select();
            if ($request) $tree_list[$k]['request_param'] = $request;
            $body = $Db->name('test_usecase_param')->where('usecase_id', $v['id'])->field('id, pid, field, value, at_value')->select();
            foreach ($body as $key => $val) {
                $body[$key]['param_type'] = $Db->name('api_body')->where('api_id', $v['api_id'])->where('field', $val['field'])->value('param_type');
            }
			if ($body) $tree_list[$k]['body_param'] = $body;
			
			$usecase = $Db->name('test_usecase')->where('id', $v['usecase_id'])->find();
			$tree_list[$k]['http_code'] = $usecase['http_code'];
		}

		$Db->return();
		$obj = new \Task\LoopSend();
		$obj->run($info['id'], $tree_list[0], $tree_list);
	}
}  
